/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicbooks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.comicbooks.ComicDetail;
import org.comixedproject.model.comicbooks.ComicTagType;
import org.comixedproject.views.View;

@Entity
@Table(name="ComicTags")
public class ComicTag {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="ComicDetailId", insertable=true, nullable=false, updatable=false)
    @NonNull
    private ComicDetail comicDetail;
    @Column(name="TagType", insertable=true, nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    @JsonProperty(value="type")
    @JsonView(value={View.ComicListView.class})
    @NonNull
    private ComicTagType type;
    @Column(name="TagValue", length=255, insertable=true, nullable=false, updatable=false)
    @JsonView(value={View.ComicListView.class})
    @JsonProperty(value="value")
    @NonNull
    private String value;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComicTag comicTag = (ComicTag)o;
        return this.type == comicTag.type && this.value.equals(comicTag.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    @Generated
    public ComicTag() {
    }

    @Generated
    public ComicTag(@NonNull ComicDetail comicDetail, @NonNull ComicTagType type, @NonNull String value) {
        if (comicDetail == null) {
            throw new NullPointerException("comicDetail is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.comicDetail = comicDetail;
        this.type = type;
        this.value = value;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicDetail getComicDetail() {
        return this.comicDetail;
    }

    @NonNull
    @Generated
    public ComicTagType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getValue() {
        return this.value;
    }
}

