/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicbooks;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import lombok.Generated;
import lombok.NonNull;
import org.comixedproject.model.comicbooks.ComicBook;
import org.comixedproject.model.metadata.MetadataSource;
import org.comixedproject.views.View;

@Entity
@Table(name="ComicMetadataSources")
public class ComicMetadataSource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToOne
    @JoinColumn(name="ComicBookId", nullable=false, updatable=false)
    @NonNull
    private ComicBook comicBook;
    @ManyToOne
    @JoinColumn(name="MetadataSourceId", nullable=false, updatable=false)
    @JsonProperty(value="metadataSource")
    @JsonView(value={View.ComicDetailsView.class})
    @NonNull
    private MetadataSource metadataSource;
    @Column(name="ReferenceId", length=32, nullable=false, updatable=true)
    @JsonProperty(value="referenceId")
    @JsonView(value={View.ComicDetailsView.class})
    @NonNull
    private String referenceId;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComicMetadataSource that = (ComicMetadataSource)o;
        return this.comicBook.equals(that.comicBook) && this.metadataSource.equals(that.metadataSource) && this.referenceId.equals(that.referenceId);
    }

    public int hashCode() {
        return Objects.hash(this.comicBook, this.metadataSource, this.referenceId);
    }

    @Generated
    public ComicMetadataSource() {
    }

    @Generated
    public ComicMetadataSource(@NonNull ComicBook comicBook, @NonNull MetadataSource metadataSource, @NonNull String referenceId) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        if (metadataSource == null) {
            throw new NullPointerException("metadataSource is marked non-null but is null");
        }
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        this.comicBook = comicBook;
        this.metadataSource = metadataSource;
        this.referenceId = referenceId;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicBook getComicBook() {
        return this.comicBook;
    }

    @NonNull
    @Generated
    public MetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    @JsonProperty(value="metadataSource")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setMetadataSource(@NonNull MetadataSource metadataSource) {
        if (metadataSource == null) {
            throw new NullPointerException("metadataSource is marked non-null but is null");
        }
        this.metadataSource = metadataSource;
    }

    @NonNull
    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @JsonProperty(value="referenceId")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setReferenceId(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        this.referenceId = referenceId;
    }
}

