/*
 * Decompiled with CFR 0.152.
 */
package org.comixedproject.model.comicbooks;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.comixedproject.model.archives.ArchiveType;
import org.comixedproject.model.comicbooks.ComicBook;
import org.comixedproject.model.comicbooks.ComicState;
import org.comixedproject.model.comicbooks.ComicTag;
import org.comixedproject.model.comicbooks.ComicType;
import org.comixedproject.model.library.LastRead;
import org.comixedproject.views.View;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.Formula;
import org.springframework.data.annotation.CreatedDate;

@Entity
@Table(name="ComicDetails")
public class ComicDetail {
    @Generated
    private static final Logger log = LogManager.getLogger(ComicDetail.class);
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @JsonView(value={View.ComicListView.class, View.DeletedPageList.class, View.LastReadList.class, View.ReadingListDetail.class})
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ComicBookId", nullable=false, updatable=false)
    @NonNull
    private ComicBook comicBook;
    @Formula(value="(SELECT CASE WHEN (ComicBookId IN (SELECT m.ComicBookId FROM ComicMetadataSources m)) THEN false ELSE true END)")
    @JsonProperty(value="unscraped")
    @JsonView(value={View.ComicListView.class})
    private Boolean unscraped;
    @Column(name="Filename", nullable=false, unique=true, length=1024)
    @JsonProperty(value="filename")
    @JsonView(value={View.ComicListView.class, View.DeletedPageList.class})
    @NonNull
    private String filename;
    @Column(name="ArchiveType", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @JsonProperty(value="archiveType")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @NonNull
    private ArchiveType archiveType;
    @Column(name="ComicState", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @JsonProperty(value="comicState")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private ComicState comicState = ComicState.ADDED;
    @Column(name="ComicType", nullable=false, updatable=true)
    @Enumerated(value=EnumType.STRING)
    @JsonProperty(value="comicType")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private ComicType comicType = ComicType.ISSUE;
    @Column(name="Publisher", length=255)
    @ColumnTransformer(write="TRIM(?)")
    @JsonProperty(value="publisher")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private String publisher;
    @Column(name="Imprint", length=255)
    @JsonProperty(value="imprint")
    @JsonView(value={View.ComicListView.class})
    private String imprint;
    @Column(name="Series", length=255)
    @ColumnTransformer(write="TRIM(?)")
    @JsonProperty(value="series")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private String series;
    @Column(name="Volume", length=4)
    @ColumnTransformer(write="TRIM(?)")
    @JsonProperty(value="volume")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private String volume;
    @Column(name="IssueNumber", length=16)
    @ColumnTransformer(write="TRIM(?)")
    @JsonProperty(value="issueNumber")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private String issueNumber;
    @JsonProperty(value="sortableIssueNumber")
    @JsonView(value={View.ComicListView.class})
    @Formula(value="(IssueNumber)")
    private String sortableIssueNumber;
    @Column(name="SortName", length=128)
    @JsonProperty(value="sortName")
    @JsonView(value={View.ComicListView.class})
    private String sortName;
    @Column(name="Title", length=128)
    @ColumnTransformer(write="TRIM(?)")
    @JsonProperty(value="title")
    @JsonView(value={View.ComicListView.class})
    private String title;
    @Column(name="Notes", length=128, nullable=true, updatable=true)
    @ColumnTransformer(write="TRIM(?)")
    @Lob
    @JsonProperty(value="notes")
    @JsonView(value={View.ComicListView.class})
    private String notes;
    @Column(name="Description")
    @ColumnTransformer(write="TRIM(?)")
    @Lob
    @JsonProperty(value="description")
    @JsonView(value={View.ComicDetailsView.class})
    private String description;
    @OneToMany(mappedBy="comicDetail", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JsonProperty(value="tags")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class})
    private Set<ComicTag> tags = new HashSet<ComicTag>();
    @Column(name="CoverDate", nullable=true)
    @Temporal(value=TemporalType.DATE)
    @JsonProperty(value="coverDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private Date coverDate;
    @Formula(value="(SELECT CASE WHEN CoverDate IS NULL THEN 0 ELSE YEAR(CoverDate) END)")
    @JsonProperty(value="yearPublished")
    @JsonView(value={View.ComicListView.class})
    private Integer yearPublished;
    @Formula(value="(SELECT CASE WHEN CoverDate IS NULL THEN 0 ELSE MONTH(CoverDate) END)")
    @JsonProperty(value="monthPublished")
    @JsonView(value={View.ComicListView.class})
    private Integer monthPublished;
    @Column(name="StoreDate", nullable=true)
    @Temporal(value=TemporalType.DATE)
    @JsonProperty(value="storeDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    private Date storeDate;
    @Column(name="AddedDate", updatable=false, nullable=false)
    @CreatedDate
    @JsonProperty(value="addedDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date addedDate = new Date();
    @OneToMany(mappedBy="comicDetail", orphanRemoval=true)
    private final List<LastRead> lastReadList = new ArrayList<LastRead>();

    @JsonProperty(value="comicId")
    @JsonView(value={View.ComicListView.class, View.LastReadList.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    public Long getComicId() {
        return this.comicBook.getId();
    }

    @JsonProperty(value="baseFilename")
    @JsonView(value={View.ComicDetailsView.class})
    public String getBaseFilename() {
        return FilenameUtils.getName((String)this.filename);
    }

    @Transient
    public File getFile() {
        return new File(this.filename);
    }

    public void setIssueNumber(String issueNumber) {
        log.trace("Setting issue number=" + issueNumber);
        if (issueNumber != null && issueNumber.startsWith("0")) {
            log.trace("Removing leading 0s from issue number");
            while (issueNumber.startsWith("0") && !issueNumber.equals("0")) {
                issueNumber = issueNumber.substring(1);
            }
        }
        this.issueNumber = issueNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComicDetail that = (ComicDetail)o;
        return this.filename.equals(that.filename) && this.archiveType == that.archiveType && this.comicState == that.comicState && this.comicType == that.comicType && Objects.equals(this.publisher, that.publisher) && Objects.equals(this.imprint, that.imprint) && Objects.equals(this.series, that.series) && Objects.equals(this.volume, that.volume) && Objects.equals(this.issueNumber, that.issueNumber) && Objects.equals(this.sortName, that.sortName) && Objects.equals(this.title, that.title) && Objects.equals(this.notes, that.notes) && Objects.equals(this.description, that.description) && Objects.equals(this.tags, that.tags) && Objects.equals(this.coverDate, that.coverDate) && Objects.equals(this.storeDate, that.storeDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filename, this.archiveType, this.comicState, this.comicType, this.publisher, this.imprint, this.series, this.volume, this.issueNumber, this.sortName, this.title, this.notes, this.description, this.tags, this.coverDate, this.storeDate});
    }

    @Generated
    public ComicDetail() {
    }

    @Generated
    public ComicDetail(@NonNull ComicBook comicBook, @NonNull String filename, @NonNull ArchiveType archiveType) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        if (archiveType == null) {
            throw new NullPointerException("archiveType is marked non-null but is null");
        }
        this.comicBook = comicBook;
        this.filename = filename;
        this.archiveType = archiveType;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public ComicBook getComicBook() {
        return this.comicBook;
    }

    @Generated
    public void setComicBook(@NonNull ComicBook comicBook) {
        if (comicBook == null) {
            throw new NullPointerException("comicBook is marked non-null but is null");
        }
        this.comicBook = comicBook;
    }

    @Generated
    public Boolean getUnscraped() {
        return this.unscraped;
    }

    @JsonProperty(value="unscraped")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setUnscraped(Boolean unscraped) {
        this.unscraped = unscraped;
    }

    @NonNull
    @Generated
    public String getFilename() {
        return this.filename;
    }

    @JsonProperty(value="filename")
    @JsonView(value={View.ComicListView.class, View.DeletedPageList.class})
    @Generated
    public void setFilename(@NonNull String filename) {
        if (filename == null) {
            throw new NullPointerException("filename is marked non-null but is null");
        }
        this.filename = filename;
    }

    @NonNull
    @Generated
    public ArchiveType getArchiveType() {
        return this.archiveType;
    }

    @JsonProperty(value="archiveType")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setArchiveType(@NonNull ArchiveType archiveType) {
        if (archiveType == null) {
            throw new NullPointerException("archiveType is marked non-null but is null");
        }
        this.archiveType = archiveType;
    }

    @Generated
    public ComicState getComicState() {
        return this.comicState;
    }

    @JsonProperty(value="comicState")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setComicState(ComicState comicState) {
        this.comicState = comicState;
    }

    @Generated
    public ComicType getComicType() {
        return this.comicType;
    }

    @JsonProperty(value="comicType")
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setComicType(ComicType comicType) {
        this.comicType = comicType;
    }

    @Generated
    public String getPublisher() {
        return this.publisher;
    }

    @JsonProperty(value="publisher")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    @Generated
    public String getImprint() {
        return this.imprint;
    }

    @JsonProperty(value="imprint")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setImprint(String imprint) {
        this.imprint = imprint;
    }

    @Generated
    public String getSeries() {
        return this.series;
    }

    @JsonProperty(value="series")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setSeries(String series) {
        this.series = series;
    }

    @Generated
    public String getVolume() {
        return this.volume;
    }

    @JsonProperty(value="volume")
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setVolume(String volume) {
        this.volume = volume;
    }

    @Generated
    public String getIssueNumber() {
        return this.issueNumber;
    }

    @Generated
    public String getSortableIssueNumber() {
        return this.sortableIssueNumber;
    }

    @Generated
    public String getSortName() {
        return this.sortName;
    }

    @JsonProperty(value="sortName")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonView(value={View.ComicDetailsView.class})
    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Set<ComicTag> getTags() {
        return this.tags;
    }

    @Generated
    public Date getCoverDate() {
        return this.coverDate;
    }

    @JsonProperty(value="coverDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setCoverDate(Date coverDate) {
        this.coverDate = coverDate;
    }

    @Generated
    public Integer getYearPublished() {
        return this.yearPublished;
    }

    @JsonProperty(value="yearPublished")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setYearPublished(Integer yearPublished) {
        this.yearPublished = yearPublished;
    }

    @Generated
    public Integer getMonthPublished() {
        return this.monthPublished;
    }

    @JsonProperty(value="monthPublished")
    @JsonView(value={View.ComicListView.class})
    @Generated
    public void setMonthPublished(Integer monthPublished) {
        this.monthPublished = monthPublished;
    }

    @Generated
    public Date getStoreDate() {
        return this.storeDate;
    }

    @JsonProperty(value="storeDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setStoreDate(Date storeDate) {
        this.storeDate = storeDate;
    }

    @Generated
    public Date getAddedDate() {
        return this.addedDate;
    }

    @JsonProperty(value="addedDate")
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    @JsonView(value={View.ComicListView.class, View.DuplicatePageDetail.class, View.ReadingListDetail.class, View.DeletedPageList.class})
    @Generated
    public void setAddedDate(Date addedDate) {
        this.addedDate = addedDate;
    }

    @Generated
    public List<LastRead> getLastReadList() {
        return this.lastReadList;
    }
}

