/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.websocket.server.AbstractWebSocketTransport;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketTransport
extends AbstractWebSocketTransport<WebSocket.Connection>
implements WebSocketFactory.Acceptor {
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    private final WebSocketFactory _factory = new WebSocketFactory((WebSocketFactory.Acceptor)this);

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux);
    }

    @Override
    public void init() {
        super.init();
        int bufferSize = this.getOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize());
        this._factory.setBufferSize(bufferSize);
        int maxMessageSize = this.getOption("maxMessageSize", bufferSize - 16);
        this._factory.setMaxTextMessageSize(maxMessageSize);
        long idleTimeout = this.getOption("idleTimeout", this._factory.getMaxIdleTime());
        this._factory.setMaxIdleTime((int)idleTimeout);
        try {
            this._factory.start();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    protected void destroy() {
        try {
            this._factory.stop();
        }
        catch (Exception x) {
            this._logger.trace("", (Throwable)x);
        }
        Executor threadPool = this.getExecutor();
        if (threadPool instanceof LifeCycle) {
            try {
                ((LifeCycle)threadPool).stop();
            }
            catch (Exception x) {
                this._logger.trace("", (Throwable)x);
            }
        }
        super.destroy();
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this._factory.acceptWebSocket(request, response)) {
            this._logger.warn("WebSocket not accepted");
            if (!response.isCommitted()) {
                response.setHeader("Connection", "close");
                response.sendError(500);
            }
        }
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        boolean sameProtocol;
        String serverProtocol = this.getProtocol();
        boolean bl = sameProtocol = serverProtocol == null && protocol == null || serverProtocol != null && serverProtocol.equals(protocol);
        if (sameProtocol) {
            WebSocketContext handshake = new WebSocketContext(request);
            return new WebSocketScheduler(handshake);
        }
        this._logger.warn("WebSocket protocols do not match: server[{}] != client[{}]", (Object)serverProtocol, (Object)protocol);
        return null;
    }

    public boolean checkOrigin(HttpServletRequest request, String origin) {
        return true;
    }

    @Override
    protected void send(WebSocket.Connection wsSession, ServerSession session, String data) {
        try {
            this.debug("Sending {}", new Object[]{data});
            wsSession.sendMessage(data);
        }
        catch (Exception x) {
            this.handleException(wsSession, session, x);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebSocketContext
    implements BayeuxContext {
        private final Principal _principal;
        private final InetSocketAddress _local;
        private final InetSocketAddress _remote;
        private final Map<String, List<String>> _headers = new HashMap<String, List<String>>();
        private final Map<String, List<String>> _parameters = new HashMap<String, List<String>>();
        private final Map<String, Object> _attributes = new HashMap<String, Object>();
        private final Map<String, String> _cookies = new HashMap<String, String>();
        private final HttpSession _session;
        private final ServletContext _context;
        private final String _url;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WebSocketContext(HttpServletRequest request) {
            this._local = new InetSocketAddress(request.getLocalAddr(), request.getLocalPort());
            this._remote = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
            for (String name : Collections.list(request.getHeaderNames())) {
                this._headers.put(name.toLowerCase(Locale.ENGLISH), Collections.unmodifiableList(Collections.list(request.getHeaders(name))));
            }
            for (String name : Collections.list(request.getParameterNames())) {
                this._parameters.put(name, Collections.unmodifiableList(Arrays.asList(request.getParameterValues(name))));
            }
            for (String name : Collections.list(request.getAttributeNames())) {
                this._attributes.put(name, request.getAttribute(name));
            }
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    this._cookies.put(c.getName(), c.getValue());
                }
            }
            this._principal = request.getUserPrincipal();
            this._session = request.getSession(false);
            if (this._session != null) {
                this._context = this._session.getServletContext();
            } else {
                ServletContext context = null;
                try {
                    HttpSession s = request.getSession(true);
                    context = s.getServletContext();
                    s.invalidate();
                }
                catch (IllegalStateException x) {
                    WebSocketTransport.this._logger.trace("", (Throwable)x);
                }
                finally {
                    this._context = context;
                }
            }
            StringBuffer url = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            this._url = url.toString();
        }

        public Principal getUserPrincipal() {
            return this._principal;
        }

        public boolean isUserInRole(String role) {
            HttpServletRequest request = WebSocketTransport.this.getCurrentRequest();
            return request != null && request.isUserInRole(role);
        }

        public InetSocketAddress getRemoteAddress() {
            return this._remote;
        }

        public InetSocketAddress getLocalAddress() {
            return this._local;
        }

        public String getHeader(String name) {
            List<String> headers = this._headers.get(name.toLowerCase(Locale.ENGLISH));
            return headers != null && headers.size() > 0 ? headers.get(0) : null;
        }

        public List<String> getHeaderValues(String name) {
            return this._headers.get(name.toLowerCase(Locale.ENGLISH));
        }

        public String getParameter(String name) {
            List<String> params = this._parameters.get(name);
            return params != null && params.size() > 0 ? params.get(0) : null;
        }

        public List<String> getParameterValues(String name) {
            return this._parameters.get(name);
        }

        public String getCookie(String name) {
            return this._cookies.get(name);
        }

        public String getHttpSessionId() {
            return this._session == null ? null : this._session.getId();
        }

        public Object getHttpSessionAttribute(String name) {
            return this._session == null ? null : this._session.getAttribute(name);
        }

        public void setHttpSessionAttribute(String name, Object value) {
            if (this._session == null) {
                throw new IllegalStateException("!session");
            }
            this._session.setAttribute(name, value);
        }

        public void invalidateHttpSession() {
            if (this._session != null) {
                this._session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return this._attributes.get(name);
        }

        public Object getContextAttribute(String name) {
            return this._context.getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this._context.getInitParameter(name);
        }

        public String getURL() {
            return this._url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WebSocketScheduler
    extends AbstractWebSocketTransport.AbstractWebSocketScheduler
    implements WebSocket.OnTextMessage {
        private volatile WebSocket.Connection _connection;

        public WebSocketScheduler(WebSocketContext context) {
            super(WebSocketTransport.this, context);
        }

        public void onOpen(WebSocket.Connection connection) {
            this._connection = connection;
        }

        public void onMessage(String data) {
            this.onMessage(this._connection, data);
        }

        @Override
        public void onClose(int code, String reason) {
            super.onClose(code, reason);
        }

        @Override
        protected void close(int code, String reason) {
            this._connection.close(code, reason);
        }

        @Override
        protected void schedule(boolean timeout, ServerMessage.Mutable expiredConnectReply) {
            this.schedule(this._connection, timeout, expiredConnectReply);
        }
    }
}

