/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.cometd.bayeux.server.BayeuxContext;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractServerTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.cometd.server.transport.HttpTransport;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.thread.Timeout;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public class WebSocketTransport
extends HttpTransport
implements WebSocketFactory.Acceptor {
    public static final String PREFIX = "ws";
    public static final String NAME = "websocket";
    public static final String PROTOCOL_OPTION = "protocol";
    public static final String BUFFER_SIZE_OPTION = "bufferSize";
    private final WebSocketFactory _factory = new WebSocketFactory((WebSocketFactory.Acceptor)this);
    private final ThreadLocal<Handshake> _handshake = new ThreadLocal();
    private String _protocol;

    public WebSocketTransport(BayeuxServerImpl bayeux) {
        super(bayeux, NAME);
        this.setOptionPrefix(PREFIX);
    }

    public void init() {
        this._protocol = this.getOption(PROTOCOL_OPTION, this._protocol);
        this._factory.setBufferSize(this.getOption(BUFFER_SIZE_OPTION, this._factory.getBufferSize()));
        this.setTimeout(this.getOption("ws.timeout", 15000L));
        this.setInterval(this.getOption("ws.interval", 2500L));
        this.setMaxInterval(this.getOption("ws.maxInterval", 15000L));
    }

    public boolean accept(HttpServletRequest request) {
        return "WebSocket".equals(request.getHeader("Upgrade"));
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.isMetaConnectDeliveryOnly()) {
            this.getBayeux().getLogger().warn("MetaConnectDeliveryOnly not implemented for websocket", new Object[0]);
            response.setHeader("Connection", "close");
            response.sendError(500);
            return;
        }
        if (!this._factory.acceptWebSocket(request, response)) {
            this.getBayeux().getLogger().warn("Websocket not accepted", new Object[0]);
            response.setHeader("Connection", "close");
            response.sendError(500);
        }
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        boolean sameProtocol;
        boolean bl = sameProtocol = this._protocol == null && protocol == null || this._protocol != null && this._protocol.equals(protocol);
        if (sameProtocol) {
            Handshake handshake = new Handshake(request);
            return new WebSocketScheduler(handshake, request.getHeader("User-Agent"));
        }
        return null;
    }

    public String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    public BayeuxContext getContext() {
        return this._handshake.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Handshake
    implements BayeuxContext {
        private final Principal _principal;
        private final InetSocketAddress _local;
        private final InetSocketAddress _remote;
        private final Map<String, List<String>> _headers = new HashMap<String, List<String>>();
        private final Map<String, List<String>> _parameters = new HashMap<String, List<String>>();
        private final Map<String, Object> _attributes = new HashMap<String, Object>();
        private final Map<String, String> _cookies = new HashMap<String, String>();
        private final HttpSession _session;
        private final ServletContext _context;
        private final String _url;

        Handshake(HttpServletRequest request) {
            this._local = new InetSocketAddress(request.getLocalAddr(), request.getLocalPort());
            this._remote = new InetSocketAddress(request.getRemoteAddr(), request.getRemotePort());
            for (String name : Collections.list(request.getHeaderNames())) {
                this._headers.put(name, Collections.unmodifiableList(Collections.list(request.getHeaders(name))));
            }
            for (String name : Collections.list(request.getParameterNames())) {
                this._parameters.put(name, Collections.unmodifiableList(Arrays.asList(request.getParameterValues(name))));
            }
            for (String name : Collections.list(request.getAttributeNames())) {
                this._attributes.put(name, request.getAttribute(name));
            }
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie c : cookies) {
                    this._cookies.put(c.getName(), c.getValue());
                }
            }
            this._principal = request.getUserPrincipal();
            this._session = request.getSession(false);
            if (this._session != null) {
                this._context = this._session.getServletContext();
            } else {
                HttpSession s = request.getSession(true);
                this._context = s.getServletContext();
                s.invalidate();
            }
            StringBuffer url = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                url.append("?").append(query);
            }
            this._url = url.toString();
        }

        public Principal getUserPrincipal() {
            return this._principal;
        }

        public boolean isUserInRole(String role) {
            HttpServletRequest request = WebSocketTransport.this.getCurrentRequest();
            return request != null && request.isUserInRole(role);
        }

        public InetSocketAddress getRemoteAddress() {
            return this._remote;
        }

        public InetSocketAddress getLocalAddress() {
            return this._local;
        }

        public String getHeader(String name) {
            List<String> headers = this._headers.get(name);
            return headers != null && headers.size() > 0 ? headers.get(0) : null;
        }

        public List<String> getHeaderValues(String name) {
            return this._headers.get(name);
        }

        public String getParameter(String name) {
            List<String> params = this._parameters.get(name);
            return params != null && params.size() > 0 ? params.get(0) : null;
        }

        public List<String> getParameterValues(String name) {
            return this._parameters.get(name);
        }

        public String getCookie(String name) {
            return this._cookies.get(name);
        }

        public String getHttpSessionId() {
            return this._session == null ? null : this._session.getId();
        }

        public Object getHttpSessionAttribute(String name) {
            return this._session == null ? null : this._session.getAttribute(name);
        }

        public void setHttpSessionAttribute(String name, Object value) {
            if (this._session == null) {
                throw new IllegalStateException("!session");
            }
            this._session.setAttribute(name, value);
        }

        public void invalidateHttpSession() {
            if (this._session != null) {
                this._session.invalidate();
            }
        }

        public Object getRequestAttribute(String name) {
            return this._attributes.get(name);
        }

        public Object getContextAttribute(String name) {
            return this._context.getAttribute(name);
        }

        public String getContextInitParameter(String name) {
            return this._context.getInitParameter(name);
        }

        public String getURL() {
            return this._url;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class WebSocketScheduler
    implements WebSocket.OnTextMessage,
    AbstractServerTransport.Scheduler {
        protected final Handshake _addresses;
        protected final String _userAgent;
        protected ServerSessionImpl _session;
        protected WebSocket.Connection _connection;
        protected ServerMessage.Mutable _connectReply;
        protected final Timeout.Task _timeoutTask = new Timeout.Task(){

            public void expired() {
                if (WebSocketScheduler.this._session != null) {
                    WebSocketScheduler.this.schedule();
                }
            }
        };

        public WebSocketScheduler(Handshake addresses, String userAgent) {
            this._addresses = addresses;
            this._userAgent = userAgent;
        }

        public void onOpen(WebSocket.Connection connection) {
            this._connection = connection;
        }

        public void onClose(int code, String message) {
            if (this._session != null) {
                this._session.cancelIntervalTimeout();
                WebSocketTransport.this.getBayeux().cancelTimeout(this._timeoutTask);
                WebSocketTransport.this.getBayeux().removeServerSession((ServerSession)this._session, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(String data) {
            boolean batch = false;
            try {
                ServerMessage.Mutable[] messages;
                WebSocketTransport.this._handshake.set(this._addresses);
                WebSocketTransport.this.getBayeux().setCurrentTransport((AbstractServerTransport)WebSocketTransport.this);
                for (ServerMessage.Mutable message : messages = ServerMessageImpl.parseServerMessages((String)data)) {
                    boolean connect = "/meta/connect".equals(message.getChannel());
                    String client_id = message.getClientId();
                    if (this._session == null || client_id != null && !client_id.equals(this._session.getId())) {
                        this._session = (ServerSessionImpl)WebSocketTransport.this.getBayeux().getSession(message.getClientId());
                    } else if (!this._session.isHandshook()) {
                        batch = false;
                        this._session = null;
                    }
                    if (!(batch || this._session == null || connect || message.isMeta())) {
                        batch = true;
                        this._session.startBatch();
                    }
                    boolean was_connected = this._session != null && this._session.isConnected();
                    ServerMessage.Mutable reply = WebSocketTransport.this.getBayeux().handle(this._session, message);
                    if (connect && reply.isSuccessful()) {
                        this._session.setUserAgent(this._userAgent);
                        this._session.setScheduler((AbstractServerTransport.Scheduler)this);
                        long timeout = this._session.calculateTimeout(WebSocketTransport.this.getTimeout());
                        if (timeout > 0L && was_connected) {
                            WebSocketTransport.this.getBayeux().startTimeout(this._timeoutTask, timeout);
                            this._connectReply = reply;
                            reply = null;
                        } else if (!was_connected) {
                            this._session.startIntervalTimeout();
                        }
                    }
                    if (reply != null) {
                        reply = WebSocketTransport.this.getBayeux().extendReply(this._session, this._session, reply);
                        if (batch) {
                            this._session.addQueue((ServerMessage)reply);
                        } else {
                            this.send((ServerMessage)reply);
                        }
                    }
                    message.setAssociated(null);
                }
            }
            catch (IOException e) {
                WebSocketTransport.this.getBayeux().getLogger().warn("", (Throwable)e);
            }
            catch (ParseException e) {
                this.handleJSONParseException(e.getMessage(), e.getCause());
            }
            finally {
                WebSocketTransport.this._handshake.set(null);
                WebSocketTransport.this.getBayeux().setCurrentTransport(null);
                if (batch) {
                    this._session.endBatch();
                }
            }
        }

        protected void handleJSONParseException(String json, Throwable exception) {
            WebSocketTransport.this.getBayeux().getLogger().debug("Error parsing JSON: " + json, exception);
        }

        public void cancel() {
        }

        public void schedule() {
            ServerSessionImpl session = this._session;
            if (session != null) {
                List queue = session.takeQueue();
                if (this._connectReply != null) {
                    queue.add(WebSocketTransport.this.getBayeux().extendReply(session, session, this._connectReply));
                    this._connectReply = null;
                    session.startIntervalTimeout();
                }
                try {
                    if (queue.size() > 0) {
                        this.send(queue);
                    }
                }
                catch (IOException e) {
                    WebSocketTransport.this.getBayeux().getLogger().warn("io ", (Throwable)e);
                }
            }
        }

        protected void send(List<ServerMessage> messages) throws IOException {
            String data = JSON.toString(messages);
            this._connection.sendMessage(data);
        }

        protected void send(ServerMessage message) throws IOException {
            String data = message.getJSON();
            this._connection.sendMessage("[" + data + "]");
        }
    }
}

