/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.bayeux.server;

import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;

public interface Authorizer {
    public Result authorize(Operation var1, ChannelId var2, ServerSession var3, ServerMessage var4);

    public static abstract class Result {
        public static Result deny(String reason) {
            return new Denied(reason);
        }

        public static Result grant() {
            return Granted.GRANTED;
        }

        public static Result ignore() {
            return Ignored.IGNORED;
        }

        public String toString() {
            return this.getClass().getSimpleName().toLowerCase();
        }

        public static final class Ignored
        extends Result {
            private static final Ignored IGNORED = new Ignored();

            private Ignored() {
            }
        }

        public static final class Granted
        extends Result {
            private static final Granted GRANTED = new Granted();

            private Granted() {
            }
        }

        public static final class Denied
        extends Result {
            private final String reason;

            private Denied(String reason) {
                if (reason == null) {
                    reason = "";
                }
                this.reason = reason;
            }

            public String getReason() {
                return this.reason;
            }

            @Override
            public String toString() {
                return super.toString() + " (reason='" + this.reason + "')";
            }
        }
    }

    public static enum Operation {
        CREATE,
        SUBSCRIBE,
        PUBLISH;

    }
}

