/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.scanner;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.cognitor.cassandra.migration.scanner.LocationScanner;
import org.cognitor.cassandra.migration.util.Ensure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarLocationScanner
implements LocationScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URI locationUri) throws IOException {
        Ensure.notNullOrEmpty(location, "location");
        Ensure.notNull(locationUri, "locationUri");
        LOGGER.debug("Scanning in jar {} in location {}", (Object)locationUri, (Object)location);
        try (FileSystem fileSystem = this.getFileSystem(locationUri);){
            Path systemPath = fileSystem.getPath(location, new String[0]);
            Set<String> set = Files.walk(systemPath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> JarLocationScanner.normalizePath(path.toString())).collect(Collectors.toSet());
            return set;
        }
    }

    private FileSystem getFileSystem(URI location) throws IOException {
        try {
            LOGGER.debug("Trying to get existing filesystem for {}", (Object)location.toString());
            return FileSystems.getFileSystem(location);
        }
        catch (FileSystemNotFoundException exception) {
            LOGGER.debug("Creating new filesystem for {}", (Object)location.toString());
            return FileSystems.newFileSystem(location, Collections.emptyMap());
        }
    }

    private static String normalizePath(String pathName) {
        if (pathName.startsWith("/")) {
            return pathName.substring(1);
        }
        return pathName;
    }
}

