/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.scanner;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.cognitor.cassandra.migration.scanner.LocationScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemLocationScanner
implements LocationScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemLocationScanner.class);
    private static final String UTF_8 = "UTF-8";

    @Override
    public Set<String> findResourceNames(String location, URI locationUri) throws IOException {
        String filePath = FileSystemLocationScanner.toFilePath(locationUri);
        File folder = new File(filePath);
        if (!folder.isDirectory()) {
            LOGGER.debug("Skipping path as it is not a directory: " + filePath);
            return new TreeSet<String>();
        }
        String classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!classPathRootOnDisk.endsWith(File.separator)) {
            classPathRootOnDisk = classPathRootOnDisk + File.separator;
        }
        LOGGER.debug("Scanning starting at classpath root in filesystem: " + classPathRootOnDisk);
        return this.findResourceNamesFromFileSystem(classPathRootOnDisk, location, folder);
    }

    private Set<String> findResourceNamesFromFileSystem(String classPathRootOnDisk, String scanRootLocation, File folder) {
        LOGGER.debug("Scanning for resources in path: {} ({})", (Object)folder.getPath(), (Object)scanRootLocation);
        File[] files = folder.listFiles();
        if (files == null) {
            return Collections.emptySet();
        }
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(classPathRootOnDisk, scanRootLocation, file));
                continue;
            }
            resourceNames.add(this.toResourceNameOnClasspath(classPathRootOnDisk, file));
        }
        return resourceNames;
    }

    private String toResourceNameOnClasspath(String classPathRootOnDisk, File file) {
        String fileName = file.getAbsolutePath().replace("\\", "/");
        return fileName.substring(classPathRootOnDisk.length());
    }

    private static String toFilePath(URI uri) {
        try {
            String filePath = new File(URLDecoder.decode(uri.getPath().replace("+", "%2b"), UTF_8)).getAbsolutePath();
            if (filePath.endsWith("/")) {
                return filePath.substring(0, filePath.length() - 1);
            }
            return filePath;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Something really strange happened", e);
        }
    }
}

