/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.keyspace;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.cognitor.cassandra.migration.keyspace.ReplicationStrategy;
import org.cognitor.cassandra.migration.util.Ensure;

public class NetworkStrategy
implements ReplicationStrategy {
    private final Map<String, Integer> dataCenters = new HashMap<String, Integer>();

    @Override
    public String getName() {
        return "NetworkTopologyStrategy";
    }

    @Override
    public String createCqlStatement() {
        if (this.getDataCenters().isEmpty()) {
            throw new IllegalStateException("There has to be at least one datacenter in order to use NetworkTopologyStrategy.");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("'class':'").append(this.getName()).append("',");
        builder.append(String.join((CharSequence)",", this.dataCenters.keySet().stream().map(dc -> "'" + dc + "':" + this.dataCenters.get(dc)).collect(Collectors.toSet())));
        builder.append("}");
        return builder.toString();
    }

    public NetworkStrategy with(String datacenter, int replicationFactor) {
        Ensure.notNullOrEmpty(datacenter, "datacenter");
        if (replicationFactor < 1) {
            throw new IllegalArgumentException("Replication Factor must be greater than zero");
        }
        this.dataCenters.put(datacenter, replicationFactor);
        return this;
    }

    public Map<String, Integer> getDataCenters() {
        return Collections.unmodifiableMap(this.dataCenters);
    }
}

