/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration.collector;

import org.cognitor.cassandra.migration.util.Ensure;

public class ScriptFile
implements Comparable {
    private final int version;
    private final String resourceName;
    private final String scriptName;

    public ScriptFile(int version, String resourceName, String scriptName) {
        this.version = version;
        this.resourceName = Ensure.notNullOrEmpty(resourceName, "resourceName");
        this.scriptName = Ensure.notNullOrEmpty(scriptName, "scriptName");
    }

    public int getVersion() {
        return this.version;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public int compareTo(Object o) {
        if (o == null || !ScriptFile.class.isAssignableFrom(o.getClass())) {
            return 1;
        }
        return Integer.compare(this.version, ((ScriptFile)o).version);
    }

    public boolean equals(Object o) {
        if (o == null || !ScriptFile.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ScriptFile other = (ScriptFile)o;
        return this.resourceName.equals(other.resourceName) && this.scriptName.equals(other.scriptName) && this.version == other.version;
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + this.resourceName.hashCode();
        result = 31 * result + this.scriptName.hashCode();
        return result;
    }
}

