/*
 * Decompiled with CFR 0.152.
 */
package org.cognitor.cassandra.migration;

import java.util.List;
import org.cognitor.cassandra.migration.Database;
import org.cognitor.cassandra.migration.DbMigration;
import org.cognitor.cassandra.migration.MigrationRepository;
import org.cognitor.cassandra.migration.util.Ensure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationTask.class);
    private final Database database;
    private final MigrationRepository repository;

    public MigrationTask(Database database, MigrationRepository repository) {
        this.database = Ensure.notNull(database, "database");
        this.repository = Ensure.notNull(repository, "repository");
    }

    public void migrate() {
        if (this.databaseIsUpToDate()) {
            LOGGER.info(String.format("Keyspace %s is already up to date at version %d", this.database.getKeyspaceName(), this.database.getVersion()));
            return;
        }
        List<DbMigration> migrations = this.repository.getMigrationsSinceVersion(this.database.getVersion());
        migrations.forEach(this.database::execute);
        LOGGER.info(String.format("Migrated keyspace %s to version %d", this.database.getKeyspaceName(), this.database.getVersion()));
        this.database.close();
    }

    private boolean databaseIsUpToDate() {
        return this.database.getVersion() >= this.repository.getLatestVersion();
    }
}

