/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.platform.time;

import java.util.HashMap;
import java.util.Map;
import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.platform.time.ExactTimePoint;
import org.jscience.mathematics.number.Number;

public class TimePointFactory<OffsetSecondsFN extends Number<OffsetSecondsFN>> {
    private NumberFactory<OffsetSecondsFN> myOffsetNumberFactory;
    private Map<EpochName, ExactTimePoint<OffsetSecondsFN>> myEpochMap;
    private ExactTimePoint<OffsetSecondsFN> myInitStamp;

    public TimePointFactory(NumberFactory<OffsetSecondsFN> offsetNF) {
        this.myOffsetNumberFactory = offsetNF;
        this.myEpochMap = new HashMap<EpochName, ExactTimePoint<OffsetSecondsFN>>();
        this.myInitStamp = this.getNowPoint();
    }

    public OffsetSecondsFN convertMillisecToSeconds(long millisec) {
        return (OffsetSecondsFN)this.myOffsetNumberFactory.makeNumberFromRatioOfLongs(millisec, 1000L);
    }

    public OffsetSecondsFN getNowOffsetFromUnixEpoch1970() {
        return this.convertMillisecToSeconds(System.currentTimeMillis());
    }

    public ExactTimePoint<OffsetSecondsFN> getNowPoint() {
        OffsetSecondsFN nowSec = this.getNowOffsetFromUnixEpoch1970();
        ExactTimePoint<OffsetSecondsFN> unixEpochRefPoint = this.getEpochReferencePoint(EpochName.UNIX_EPOCH_1970);
        return unixEpochRefPoint.addOffsetSeconds(nowSec);
    }

    public ExactTimePoint<OffsetSecondsFN> getNowPointPlusOffsetSec(OffsetSecondsFN offsetSec) {
        ExactTimePoint<OffsetSecondsFN> nowPoint = this.getNowPoint();
        return nowPoint.addOffsetSeconds(offsetSec);
    }

    public ExactTimePoint<OffsetSecondsFN> getNowPointPlusOffsetMillisec(long millisec) {
        OffsetSecondsFN offsetSec = this.convertMillisecToSeconds(millisec);
        return this.getNowPointPlusOffsetSec(offsetSec);
    }

    public ExactTimePoint<OffsetSecondsFN> getEpochReferencePoint(EpochName en) {
        ExactTimePoint rp = this.myEpochMap.get((Object)en);
        if (rp == null) {
            if (en == EpochName.UNIX_EPOCH_1970) {
                // empty if block
            }
            ExactTimePoint<OffsetSecondsFN> unixEpochStamp = this.getEpochReferencePoint(EpochName.UNIX_EPOCH_1970);
            rp = new ExactTimePoint<OffsetSecondsFN>(){

                @Override
                public OffsetSecondsFN findMyOffsetToReferencePoint(ExactTimePoint<OffsetSecondsFN> otherPoint) {
                    if (otherPoint.equals(this)) {
                        return TimePointFactory.this.myOffsetNumberFactory.getZero();
                    }
                    Object reverseOffset = otherPoint.findMyOffsetToReferencePoint(otherPoint);
                    return (Number)reverseOffset.opposite();
                }
            };
            this.myEpochMap.put(en, rp);
        }
        return rp;
    }

    public ExactTimePoint<OffsetSecondsFN> getOffsetFromEpoch(EpochName epoch, OffsetSecondsFN offset) {
        return null;
    }

    public ExactTimePoint<OffsetSecondsFN> getCurrentSysTimeOffsetFromEpoch(EpochName epoch) {
        return null;
    }

    public static enum EpochName {
        UNIX_EPOCH_1970,
        MILLENIUM_EPOCH_2000,
        TP_FACTORY_INIT_STAMP;

    }
}

