/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.world;

import java.util.ArrayList;
import java.util.List;
import org.cogchar.api.animoid.protocol.SmallAngle;
import org.cogchar.api.animoid.world.WorldGoalPosition;
import org.cogchar.api.animoid.world.WorldJoint;

public class SummableWorldJointList<WJ extends WorldJoint> {
    private List<WJ> myWorldJoints = new ArrayList<WJ>();

    public void addWorldJoint(WJ wj) {
        this.myWorldJoints.add(wj);
    }

    public boolean contains(WJ wj) {
        return this.myWorldJoints.contains(wj);
    }

    public double getMaxTotalWorldPosDeg() {
        double maxTotalDeg = 0.0;
        for (WorldJoint wj : this.myWorldJoints) {
            maxTotalDeg += wj.getWorldMaxDegreesOffset();
        }
        return maxTotalDeg;
    }

    public double getMinTotalWorldPosDeg() {
        double minTotalDeg = 0.0;
        for (WorldJoint wj : this.myWorldJoints) {
            minTotalDeg += wj.getWorldMinDegreesOffset();
        }
        return minTotalDeg;
    }

    public SmallAngle getMaxTotalWorldPosAngle() {
        return SmallAngle.makeFromDeg(this.getMaxTotalWorldPosDeg());
    }

    public SmallAngle getMinTotalWorldPosAngle() {
        return SmallAngle.makeFromDeg(this.getMinTotalWorldPosDeg());
    }

    public WorldGoalPosition getTruncatedGoalPosition(WorldGoalPosition wgp) {
        double maxDeg = this.getMaxTotalWorldPosDeg() - 0.001;
        if (wgp.degrees > maxDeg) {
            return wgp.makeAdjustedPosition(maxDeg - wgp.degrees);
        }
        double minDeg = this.getMinTotalWorldPosDeg() + 0.001;
        if (wgp.degrees < minDeg) {
            return wgp.makeAdjustedPosition(minDeg - wgp.degrees);
        }
        return wgp;
    }
}

