/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.world;

import java.util.ArrayList;
import java.util.List;
import org.cogchar.api.animoid.protocol.JVFrame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointVelocityAROMPS;
import org.cogchar.api.animoid.world.WorldGoalPosition;
import org.cogchar.api.animoid.world.WorldJointTrajectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummableWJTrajectoryList<Traj extends WorldJointTrajectory> {
    private static Logger theLogger = LoggerFactory.getLogger((String)SummableWJTrajectoryList.class.getName());
    private List<Traj> myTrajectories = new ArrayList<Traj>();

    public Traj getTrajectoryForJoint(Joint j) {
        for (WorldJointTrajectory t : this.myTrajectories) {
            if (!t.getWorldJoint().getJoint().equals(j)) continue;
            return (Traj)t;
        }
        return null;
    }

    public void addTrajectory(Traj t) {
        this.myTrajectories.add(t);
    }

    public List<Traj> getTrajectories() {
        return this.myTrajectories;
    }

    public double getTotalInitialWorldPositionDeg() {
        double totalPos = 0.0;
        for (WorldJointTrajectory t : this.myTrajectories) {
            double twpd = t.getInitialJointStateSnap().getWorldPosDeg();
            totalPos += twpd;
        }
        return totalPos;
    }

    public double getTotalWorldRoomDegAboveInitPos() {
        double totalRoom = 0.0;
        for (WorldJointTrajectory t : this.myTrajectories) {
            double troom = t.getInitialJointStateSnap().getRoomAbovePosInWorldDeg();
            totalRoom += troom;
        }
        return totalRoom;
    }

    public double getTotalWorldRoomDegBelowInitPos() {
        double totalRoom = 0.0;
        for (WorldJointTrajectory t : this.myTrajectories) {
            double troom = t.getInitialJointStateSnap().getRoomBelowPosInWorldDeg();
            totalRoom += troom;
        }
        return totalRoom;
    }

    public boolean isGoalInRange(WorldGoalPosition wgp, boolean warnOnFailure) {
        double worldGoalDeltaDeg = wgp.deltaDegrees;
        if (worldGoalDeltaDeg > 0.0) {
            double totalRoomAbove = this.getTotalWorldRoomDegAboveInitPos();
            if (worldGoalDeltaDeg > totalRoomAbove) {
                if (warnOnFailure) {
                    theLogger.warn("Goal is out of range on high side[goalDeltaDeg=" + worldGoalDeltaDeg + ", totalRoomAbove=" + totalRoomAbove);
                }
                return false;
            }
        } else {
            double totalRoomBelow = this.getTotalWorldRoomDegBelowInitPos();
            if (worldGoalDeltaDeg < -1.0 * totalRoomBelow) {
                if (warnOnFailure) {
                    theLogger.warn("Goal is out of range on low side[goalDeltaDeg=" + worldGoalDeltaDeg + ", totalRoomBelow=" + totalRoomBelow);
                }
                return false;
            }
        }
        return true;
    }

    public JVFrame getVelocityFrameForJumpFromStartToTime(double targetOffsetSec) {
        JVFrame velFrame = new JVFrame();
        for (WorldJointTrajectory t : this.myTrajectories) {
            JointVelocityAROMPS jvel = t.getJointVelocityForJumpFromStartToTarget(targetOffsetSec);
            velFrame.addPosition(jvel);
        }
        return velFrame;
    }
}

