/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;

public class SmallAngle
implements Serializable {
    private double myValueRad;

    public static SmallAngle makeFromRad(double rval) {
        SmallAngle a = new SmallAngle();
        a.myValueRad = SmallAngle.normalizedAngle(rval);
        return a;
    }

    public static SmallAngle makeFromDeg(double dval) {
        double rad = Math.toRadians(dval);
        return SmallAngle.makeFromRad(rad);
    }

    public double getRadians() {
        return this.myValueRad;
    }

    public double getDegrees() {
        return Math.toDegrees(this.myValueRad);
    }

    public SmallAngle add(SmallAngle other) {
        double totalRad = this.getRadians() + other.getRadians();
        return SmallAngle.makeFromRad(totalRad);
    }

    public SmallAngle subtract(SmallAngle other) {
        double totalRad = this.getRadians() - other.getRadians();
        return SmallAngle.makeFromRad(totalRad);
    }

    public SmallAngle multiply(double scale) {
        double totalRad = this.getRadians() * scale;
        return SmallAngle.makeFromRad(totalRad);
    }

    public static double normalizedAngle(double ang) {
        double circleAngle = Math.PI * 2;
        double circlesMag = Math.abs(ang / circleAngle);
        double fullCirclesMag = Math.round(circlesMag);
        double fullCircles = fullCirclesMag * Math.signum(ang);
        double normal = ang - fullCircles * circleAngle;
        return normal;
    }

    public String toString() {
        return "SmallAngle[rad=" + this.getRadians() + ", deg=" + this.getDegrees() + "]";
    }

    public String getDegreesText() {
        double deg = this.getDegrees();
        return String.format("%+8.4f", deg);
    }
}

