/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cogchar.api.animoid.protocol.Joint;

public class Robot
implements Serializable {
    private String myName;
    private Map<String, Joint> myJointsByName = new HashMap<String, Joint>();
    private Map<Integer, Joint> myJointsByOldLogicalJointNumber = new HashMap<Integer, Joint>();

    public Robot(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }

    public void registerJoint(Joint j) {
        this.myJointsByName.put(j.getJointName(), j);
        this.myJointsByOldLogicalJointNumber.put(j.oldLogicalJointNumber, j);
    }

    public Joint getJointForName(String n) {
        return this.myJointsByName.get(n);
    }

    public Joint getJointForOldLogicalNumber(Integer oln) {
        return this.myJointsByOldLogicalJointNumber.get(oln);
    }

    public Set<String> getJointNameSet() {
        Set<String> jointNameSet = this.myJointsByName.keySet();
        return jointNameSet;
    }

    public Collection<Joint> getJoints() {
        return this.myJointsByName.values();
    }
}

