/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointStateItem;

public class JointPositionCache<JP extends JointPosition> {
    public int myRegisteredCounter;
    public int myCacheHitCounter;
    private Map<Joint, Line> myLines = new HashMap<Joint, Line>();

    private Line findOrMakeLine(Joint j) {
        Line l = this.myLines.get(j);
        if (l == null) {
            l = new Line();
            l.myJoint = j;
            this.myLines.put(j, l);
        }
        return l;
    }

    public JP findOrRegisterJointPos(JP candidate) {
        Joint j = ((JointStateItem)candidate).getJoint();
        Line l = this.findOrMakeLine(j);
        return l.findOrRegisterJP(candidate);
    }

    private class Line {
        Joint myJoint;
        List<JP> myPositions = new ArrayList();

        private Line() {
        }

        public JP findOrRegisterJP(JP candidate) {
            for (JointPosition jp : this.myPositions) {
                if (!jp.equals(candidate)) continue;
                ++JointPositionCache.this.myCacheHitCounter;
                return jp;
            }
            this.myPositions.add(candidate);
            ++JointPositionCache.this.myRegisteredCounter;
            return candidate;
        }
    }
}

