/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.JointStateItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JointPosition
extends JointStateItem {
    private static Logger theLogger = LoggerFactory.getLogger((String)JointPosition.class.getName());
    private Rationale myRationale;

    public JointPosition(Joint j) {
        super(j);
    }

    @Override
    public JointPosition copy() {
        JointPosition cjp = new JointPosition(this.getJoint());
        cjp.copyStateFrom(this);
        return cjp;
    }

    public String toString() {
        JointStateCoordinateType ctype = this.getCoordinateType();
        Double dval = this.getCoordinateFloat(ctype);
        return "JointPosition[" + this.getJoint().toString() + ", coordType=" + (Object)((Object)ctype) + ", coordFloat=" + dval + "]";
    }

    public void setRationale(Rationale r) {
        this.myRationale = r;
    }

    public Rationale getRationale() {
        return this.myRationale;
    }

    public static JointPosition sumJointPositions(JointPosition jp1, JointPosition jp2) {
        return JointPosition.weightedSumJointPositions(jp1, 1.0, jp2, 1.0);
    }

    public static JointPosition weightedSumJointPositions(JointPosition jp1, Double w1, JointPosition jp2, Double w2) {
        if (w1 == null || w2 == null) {
            theLogger.warn("Unable to take the weighted sum with null weights for Joints: " + jp1 + ", and " + jp2);
            return null;
        }
        JointPosition result = null;
        if (jp1 != null) {
            if (jp2 != null) {
                JointStateCoordinateType ct2;
                Joint j2;
                Joint j1 = jp1.getJoint();
                if (!j1.equals(j2 = jp2.getJoint())) {
                    throw new RuntimeException("Attempted to sum disparate joints: " + j1 + " and " + j2);
                }
                JointStateCoordinateType ct1 = jp1.getCoordinateType();
                if (ct1 == (ct2 = jp2.getCoordinateType())) {
                    switch (ct1) {
                        case FLOAT_ABS_RANGE_OF_MOTION: {
                            if (w1 + w2 > 1.0) {
                                double sum = w1 + w2;
                                double nw1 = w1 / sum;
                                double nw2 = w2 / sum;
                                theLogger.warn("Weights: " + w1 + ", and " + w2 + " are greater than 1.\n" + "The weights have been normalized to " + nw1 + ", and " + nw2);
                                w1 = nw1;
                                w2 = nw2;
                            }
                        }
                        case FLOAT_VEL_RANGE_OF_MOTION_PER_SEC: 
                        case FLOAT_ACC_RANGE_OF_MOTION_PSPS: 
                        case FLOAT_REL_RANGE_OF_MOTION: {
                            Double v1 = jp1.getCoordinateFloat(ct1);
                            Double v2 = jp2.getCoordinateFloat(ct2);
                            Double sum = v1 * w1 + v2 * w2;
                            result = new JointPosition(j1);
                            result.setCoordinateFloat(ct1, sum);
                        }
                    }
                }
                if (result == null) {
                    throw new RuntimeException("Can't sum " + (Object)((Object)ct1) + " and " + (Object)((Object)ct2) + " for joint " + j1);
                }
            } else {
                result = jp1;
            }
        } else if (jp2 != null) {
            result = jp2;
        }
        return result;
    }

    public JointPosition integrate(double time) {
        JointStateCoordinateType ct = this.getCoordinateType();
        double val = this.getCoordinateFloat(ct);
        JointPosition result = new JointPosition(this.getJoint());
        switch (ct) {
            case FLOAT_ACC_RANGE_OF_MOTION_PSPS: {
                result.setCoordinateFloat(JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC, val * time);
                break;
            }
            case FLOAT_VEL_RANGE_OF_MOTION_PER_SEC: {
                result.setCoordinateFloat(JointStateCoordinateType.FLOAT_REL_RANGE_OF_MOTION, val * time);
                break;
            }
            default: {
                result = null;
                theLogger.warn("Can't integrate: " + (Object)((Object)ct) + " for joint " + this.getJoint());
                throw new RuntimeException("Attempted to integrate non-derivative coordinate " + (Object)((Object)ct));
            }
        }
        return result;
    }

    public static JointPosition differentiate(JointStateCoordinateType outType, JointPosition prevPos, JointPosition currPos, double timeSec) {
        JointStateCoordinateType inType;
        if (outType.equals((Object)JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC)) {
            inType = JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION;
        } else if (outType.equals((Object)JointStateCoordinateType.FLOAT_ACC_RANGE_OF_MOTION_PSPS)) {
            inType = JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC;
        } else {
            throw new RuntimeException("Can't differentiate to produce output type: " + (Object)((Object)outType));
        }
        double rate = JointPosition.computeRateOfChange(inType, prevPos, currPos, timeSec);
        JointPosition derivJP = new JointPosition(prevPos.getJoint());
        derivJP.setCoordinateFloat(outType, rate);
        return derivJP;
    }

    public void addDelta(JointPosition delta) {
        JointStateCoordinateType ct = this.getCoordinateType();
        JointStateCoordinateType dct = delta.getCoordinateType();
        double val = this.getCoordinateFloat(ct);
        double deltaVal = delta.getCoordinateFloat(dct);
        if (ct != JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION || dct != JointStateCoordinateType.FLOAT_REL_RANGE_OF_MOTION) {
            throw new RuntimeException("Can't add delta " + (Object)((Object)dct) + " to " + (Object)((Object)ct) + " on joint " + this.getJoint());
        }
        double updatedVal = val + deltaVal;
        this.setCoordinateFloat(ct, updatedVal);
    }

    public JointPosition convertToCooordinateType(JointStateCoordinateType ctype) {
        JointStateCoordinateType mytype = this.getCoordinateType();
        if (ctype.equals((Object)mytype)) {
            return this.copy();
        }
        Joint j = this.getJoint();
        double origFloatVal = this.getCoordinateFloat(mytype);
        JointPosition cjp = new JointPosition(j);
        try {
            if (ctype == JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION && mytype == JointStateCoordinateType.FLOAT_ABS_LOPSIDED_PIECEWISE_LINEAR) {
                double convVal = j.convertLopsidedFloatToROM(origFloatVal);
                cjp.setCoordinateFloat(ctype, convVal);
            } else if (ctype == JointStateCoordinateType.FLOAT_ABS_LOPSIDED_PIECEWISE_LINEAR && mytype == JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION) {
                double convVal = j.convertROMtoLopsidedFloat(origFloatVal);
                cjp.setCoordinateFloat(ctype, convVal);
            } else {
                theLogger.warn("Can't convert from " + (Object)((Object)mytype) + " to " + (Object)((Object)ctype));
                cjp = null;
            }
        }
        catch (Throwable t) {
            theLogger.error("problem converting jointPos coordinate for " + j, t);
            cjp = null;
        }
        return cjp;
    }

    public static enum Rationale {
        OPEN_LOOP,
        CLOSED_LOOP,
        BLENDED;

    }
}

