/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.api.animoid.protocol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.JointStateItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frame<JP extends JointPosition>
implements Serializable {
    private static Logger theLogger = LoggerFactory.getLogger((String)Frame.class.getName());
    private List<JP> myPositions = new ArrayList<JP>();

    public void addPosition(JP jp) {
        if (jp == null) {
            throw new RuntimeException("Cannot add null jp");
        }
        this.myPositions.add(jp);
    }

    public List<JP> getAllPositions() {
        return this.myPositions;
    }

    public List<JP> getNonzeroPositions() {
        ArrayList<JointPosition> nzps = new ArrayList<JointPosition>();
        for (JointPosition jp : this.myPositions) {
            if (jp.isZero()) continue;
            nzps.add(jp);
        }
        return nzps;
    }

    public JP getJointPositionForJoint(Joint j) {
        for (JointPosition jp : this.myPositions) {
            if (!jp.getJoint().equals(j)) continue;
            return (JP)jp;
        }
        return null;
    }

    public JP getJointPositionForOldLogicalJointNumber(Integer jointID) {
        for (JointPosition jp : this.myPositions) {
            if (!jp.getJoint().oldLogicalJointNumber.equals(jointID)) continue;
            return (JP)jp;
        }
        return null;
    }

    public Set<Joint> getUsedJointSet() {
        HashSet<Joint> usedJoints = new HashSet<Joint>();
        for (JointPosition jp : this.myPositions) {
            usedJoints.add(jp.getJoint());
        }
        return usedJoints;
    }

    public String dumpAllPositions() {
        return JointStateItem.dumpStateList(this.myPositions);
    }

    public String dumpNonzeroPositions() {
        return JointStateItem.dumpStateList(this.getNonzeroPositions());
    }

    public void transformOtherFrame(Frame targetFrame, Set<Joint> permittedJointMask, boolean okToAddDim) {
        for (JointPosition sourceJP : this.myPositions) {
            Joint sourceJ = sourceJP.getJoint();
            JointStateCoordinateType sourceCT = sourceJP.getCoordinateType();
            if (!permittedJointMask.contains(sourceJ)) continue;
            JP targetJP = targetFrame.getJointPositionForJoint(sourceJ);
            if (targetJP != null) {
                double resultPos;
                JointStateCoordinateType targetCT = ((JointStateItem)targetJP).getCoordinateType();
                if (targetCT != JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION) {
                    theLogger.warn("Cannot play animation into JP of coordinate type: " + (Object)((Object)targetCT));
                    continue;
                }
                if (sourceCT != JointStateCoordinateType.FLOAT_REL_RANGE_OF_MOTION) {
                    theLogger.warn("Cannot play animation from JP of coordinate type: " + (Object)((Object)sourceCT));
                    continue;
                }
                double targetPrePos = ((JointStateItem)targetJP).getCoordinateFloat(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
                double increment = sourceJP.getCoordinateFloat(JointStateCoordinateType.FLOAT_REL_RANGE_OF_MOTION);
                double distFromRangeCenter = Math.abs(targetPrePos - 0.5);
                double compressionMultiplier = 1.0 - 2.0 * distFromRangeCenter;
                if ((targetPrePos - 0.5) * increment < 0.0) {
                    compressionMultiplier = 1.0;
                }
                if ((resultPos = targetPrePos + increment * compressionMultiplier) <= 0.0) {
                    resultPos = 0.0;
                    theLogger.warn("Truncated motion at 0.0 ABS_ROM position of " + sourceJ);
                }
                if (resultPos >= 1.0) {
                    resultPos = 1.0;
                    theLogger.warn("Truncated motion at 1.0 ABS_ROM position of " + sourceJ);
                }
                ((JointStateItem)targetJP).setCoordinateFloat(targetCT, resultPos);
                continue;
            }
            if (!okToAddDim) continue;
            theLogger.warn("Dimension adding not implemented yet!");
        }
    }

    public Frame copyAndConvert(JointStateCoordinateType targetCoordinateType) {
        Frame<JointPosition> resultFrame = null;
        if (targetCoordinateType == JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION || targetCoordinateType == JointStateCoordinateType.FLOAT_ABS_LOPSIDED_PIECEWISE_LINEAR) {
            resultFrame = new Frame<JointPosition>();
            for (JointPosition sourceJP : this.myPositions) {
                JointPosition convertedJP = sourceJP.convertToCooordinateType(targetCoordinateType);
                if (convertedJP == null) continue;
                resultFrame.addPosition(convertedJP);
            }
        } else {
            throw new RuntimeException("Cannot convert to coordinate type: " + (Object)((Object)targetCoordinateType));
        }
        return resultFrame;
    }

    public Frame copy() {
        Frame<JointPosition> resultFrame = new Frame<JointPosition>();
        for (JointPosition sourceJP : this.myPositions) {
            JointPosition destJP = sourceJP.copy();
            resultFrame.addPosition(destJP);
        }
        return resultFrame;
    }

    public void shallowCopyPositionsFrom(Frame<JP> source) {
        for (JointPosition sourceJP : source.myPositions) {
            this.addPosition(sourceJP);
        }
    }

    public static Frame sumCompatibleFrames(Frame f1, Frame f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null) {
            return f1;
        }
        Set<Joint> js1 = f1.getUsedJointSet();
        Set<Joint> js2 = f2.getUsedJointSet();
        HashSet<Joint> allJoints = new HashSet<Joint>(js1);
        allJoints.addAll(js2);
        return Frame.weightedSumSelectedJoints(f1, 1.0, f2, 1.0, allJoints);
    }

    public static Frame weightedSumCommonJoints(Frame f1, double w1, Frame f2, double w2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        Set<Joint> js1 = f1.getUsedJointSet();
        Set<Joint> js2 = f2.getUsedJointSet();
        HashSet<Joint> commonJoints = new HashSet<Joint>(js1);
        commonJoints.retainAll(js2);
        return Frame.weightedSumSelectedJoints(f1, w1, f2, w2, commonJoints);
    }

    public static Frame weightedSumSelectedJoints(Frame f1, double w1, Frame f2, double w2, Set<Joint> selJoints) {
        Frame<JointPosition> result = new Frame<JointPosition>();
        for (Joint j : selJoints) {
            Object jp1 = f1.getJointPositionForJoint(j);
            Object jp2 = f2.getJointPositionForJoint(j);
            JointPosition sumJP = JointPosition.weightedSumJointPositions(jp1, w1, jp2, w2);
            result.addPosition(sumJP);
        }
        return result;
    }

    public static boolean verifySameJointsUsed(Frame f1, Frame f2) {
        Set<Joint> used2;
        Set<Joint> used1 = f1.getUsedJointSet();
        if (!used1.equals(used2 = f2.getUsedJointSet())) {
            theLogger.error("Joint sets are not equal.  #1=" + used1 + ", #2=" + used2);
            throw new RuntimeException("Joint sets are not equal - see warning msg");
        }
        return true;
    }

    public static Frame computeDerivativeFrame(JointStateCoordinateType outType, Frame prevPosAR, Frame currPosAR, double timeSec) {
        if (!Frame.verifySameJointsUsed(prevPosAR, currPosAR)) {
            theLogger.warn("Used joints differ for prev=" + prevPosAR + " and curr=" + currPosAR);
            return null;
        }
        Frame<JointPosition> result = new Frame<JointPosition>();
        Set<Joint> usedJoints = prevPosAR.getUsedJointSet();
        for (Joint j : usedJoints) {
            Object prevJP = prevPosAR.getJointPositionForJoint(j);
            Object currJP = currPosAR.getJointPositionForJoint(j);
            JointPosition derivJP = JointPosition.differentiate(outType, prevJP, currJP, timeSec);
            result.addPosition(derivJP);
        }
        return result;
    }

    public Frame integrate(double time) {
        Frame<JointPosition> result = new Frame<JointPosition>();
        for (JointPosition jp : this.getAllPositions()) {
            JointPosition ijp = jp.integrate(time);
            result.addPosition(ijp);
        }
        return result;
    }

    public void multiplyByScalar(double scalar) {
        for (JointPosition jp : this.getAllPositions()) {
            jp.multiplyByScalar(scalar);
        }
    }

    public void addDeltaFrame(Frame delta) {
        for (JointPosition jp : this.getAllPositions()) {
            Joint j = jp.getJoint();
            JP deltaJP = delta.getJointPositionForJoint(j);
            if (deltaJP == null) continue;
            jp.addDelta((JointPosition)deltaJP);
        }
    }

    public void truncate() {
        for (JointPosition jp : this.getAllPositions()) {
            jp.truncate();
        }
    }

    public void verifyCoordinateTypeCompatibility(JointStateCoordinateType ctype) {
        for (JointPosition jp : this.getAllPositions()) {
            jp.verifyCoordinateTypeCompatibility(ctype);
        }
    }

    public Frame getSubframe(Set<Joint> joints, boolean ignoreMissingPositions) {
        Frame<JP> resultF = new Frame<JP>();
        for (Joint j : joints) {
            JP jp = this.getJointPositionForJoint(j);
            if (jp != null) {
                resultF.addPosition(jp);
                continue;
            }
            if (ignoreMissingPositions) continue;
            throw new RuntimeException("Missing expected jointPosition for " + j);
        }
        return resultF;
    }

    public double computeNorm(double normPower, JointStateCoordinateType ctype) {
        double sum = 0.0;
        for (JointPosition jp : this.getAllPositions()) {
            double jv = jp.getCoordinateFloat(ctype);
            double term = Math.abs(Math.pow(jv, normPower));
            sum += term;
        }
        double powInv = 1.0 / normPower;
        double norm = Math.pow(sum, powInv);
        return norm;
    }

    public String toString() {
        return "Frame[" + this.myPositions + "]";
    }
}

