/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.oldconfig;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntMatrixFuncs {
    private static Logger theLogger = LoggerFactory.getLogger((String)IntMatrixFuncs.class.getName());

    public static int[][] readDataIntoMatrix(LineNumberReader lnr) throws Throwable {
        String line;
        Object result = null;
        ArrayList<int[]> rowList = new ArrayList<int[]>();
        do {
            int lineNumber = lnr.getLineNumber();
            line = lnr.readLine();
            theLogger.debug("Got line # " + lineNumber + " : " + line);
            if (line == null || line.trim().length() <= 0) continue;
            if (!line.startsWith("#")) {
                String[] tokens = line.split("\\s*,\\s*");
                theLogger.debug("Got " + tokens.length + " tokens");
                int[] row = new int[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    int parsed;
                    row[i] = parsed = Integer.parseInt(tokens[i]);
                }
                rowList.add(row);
                continue;
            }
            theLogger.debug("Skipping comment line");
        } while (line != null);
        result = new int[rowList.size()][];
        rowList.toArray((T[])result);
        return result;
    }

    public static boolean verifyMatrixWidth(int[][] matrix, int expectedColumnCount) {
        for (int i = 0; i < matrix.length; ++i) {
            if (matrix[i].length == expectedColumnCount) continue;
            theLogger.error("Expected " + expectedColumnCount + " columns, but found " + matrix[i].length + " columns in row " + i);
            return false;
        }
        return true;
    }

    public static int[][] readAndVerifyMatrixFile(String filename, int numColumns) throws Throwable {
        boolean widthOK;
        FileReader fr = new FileReader(filename);
        LineNumberReader lnr = new LineNumberReader(fr);
        int[][] matrix = IntMatrixFuncs.readDataIntoMatrix(lnr);
        lnr.close();
        fr.close();
        if (numColumns > 0 && !(widthOK = IntMatrixFuncs.verifyMatrixWidth(matrix, numColumns))) {
            throw new Exception("File " + filename + " contains rows not matching expected width: " + numColumns);
        }
        theLogger.trace("Read int[][] matrix of " + matrix.length + " rows, and verified column width");
        return matrix;
    }
}

