/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cogchar.animoid.calc.estimate.PositionEstimator;
import org.cogchar.animoid.calc.estimate.TimeKeeper;
import org.cogchar.animoid.job.AnimoidJob;
import org.cogchar.animoid.job.BlinkJob;
import org.cogchar.animoid.job.MotionJob;
import org.cogchar.animoid.job.VisemeJob;
import org.cogchar.api.animoid.config.bonus.AnimoidConfig;
import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.JVFrame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.platform.util.TimeUtils;
import org.cogchar.zzz.platform.stub.JobSpaceStub;
import org.cogchar.zzz.platform.stub.JobStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlenderJob
extends AnimoidJob
implements PositionEstimator,
TimeKeeper {
    private static Logger theLogger = LoggerFactory.getLogger((String)BlenderJob.class.getName());
    private Frame myPrevInputPosFrame;
    private Frame myPrevOutputPosFrame;
    private Frame myPrevNominalVel;
    private long myPrevTimestampMsec;
    private List<MotionJob> myMotionJobs = new ArrayList<MotionJob>();
    public BlinkJob theTestBlinkJob;
    public VisemeJob theTestVisemeJob;
    private long myFirstTimestampMsec;
    private long myLastKeyframeTimestampMsec;
    private long myTotalFramesProcessed = 0L;

    public BlenderJob(AnimoidConfig aconf) {
        super(aconf);
    }

    public synchronized void registerMotionJob(MotionJob mj) {
        this.myMotionJobs.add(mj);
        mj.setTimeKeeper(this);
    }

    public synchronized void unregisterMotionJob(MotionJob mj) {
        this.myMotionJobs.remove((Object)mj);
    }

    protected synchronized void dropDeadJobs() {
        Iterator<MotionJob> mji = this.myMotionJobs.iterator();
        while (mji.hasNext()) {
            MotionJob mj = mji.next();
            if (mj.mayBeRunnableNowOrLater()) continue;
            theLogger.info("Dropping motion job: " + (Object)((Object)mj));
            mji.remove();
        }
    }

    protected Collection<MotionJob> getMotionJobs() {
        return this.myMotionJobs;
    }

    protected Set<Joint> compileCautionJoints() {
        Collection<MotionJob> jobs = this.getMotionJobs();
        HashSet<Joint> resultSet = new HashSet<Joint>();
        for (MotionJob mj : jobs) {
            Collection<Joint> jobCautionJoints = mj.getCautionJoints();
            if (jobCautionJoints == null) continue;
            resultSet.addAll(jobCautionJoints);
        }
        return resultSet;
    }

    @Override
    public Double getNominalSecPerFrame() {
        return this.getAnimoidConfig().getSecondsPerFrame();
    }

    @Override
    public Double getFrameDurationSmoothingFactor() {
        return this.getAnimoidConfig().getFrameDurationSmoothingFactor();
    }

    public synchronized Frame transformFrame(Frame currPosAbsRomFrame) {
        long xformStartStamp = TimeUtils.currentTimeMillis();
        double frameDeltaSec = (double)(xformStartStamp - this.myPrevTimestampMsec) / 1000.0;
        theLogger.trace("****************** Starting xform at: " + xformStartStamp + ", which is " + frameDeltaSec + " sec since last frame-xform-start");
        if (this.myPrevOutputPosFrame == null) {
            this.myPrevOutputPosFrame = currPosAbsRomFrame;
            this.myPrevInputPosFrame = currPosAbsRomFrame;
            this.myPrevTimestampMsec = xformStartStamp - Math.round(this.getNominalSecPerFrame() * 1000.0);
            this.myFirstTimestampMsec = xformStartStamp;
            this.myLastKeyframeTimestampMsec = xformStartStamp;
        }
        Frame prevVelFrame = Frame.computeDerivativeFrame(JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC, this.myPrevInputPosFrame, currPosAbsRomFrame, this.getNominalSecPerFrame());
        JVFrame prevJVFrame = JVFrame.makeFrom(prevVelFrame);
        JVFrame velSumFrame = new JVFrame();
        HashMap contribCounts = new HashMap();
        Set<Joint> cautionJoints = this.compileCautionJoints();
        this.dropDeadJobs();
        Collection<MotionJob> jobs = this.getMotionJobs();
        Frame currentPosEstAbsROM = this.estimatePositionNow(true);
        for (MotionJob mj : jobs) {
            JVFrame jobVelFrame = mj.contributeVelFrame(currentPosEstAbsROM, prevJVFrame, cautionJoints);
            if (jobVelFrame == null) continue;
            velSumFrame = JVFrame.sumJVFrames(velSumFrame, jobVelFrame);
        }
        JVFrame averageV = velSumFrame;
        Frame deltaP = averageV.integrate(this.getNominalSecPerFrame());
        Frame nextP = currPosAbsRomFrame.copy();
        nextP.addDeltaFrame(deltaP);
        nextP.truncate();
        Frame betterVelEstimate = Frame.computeDerivativeFrame(JointStateCoordinateType.FLOAT_VEL_RANGE_OF_MOTION_PER_SEC, currPosAbsRomFrame, nextP, this.getNominalSecPerFrame());
        this.myPrevInputPosFrame = currPosAbsRomFrame;
        this.myPrevOutputPosFrame = nextP;
        this.myPrevNominalVel = betterVelEstimate;
        long xformEndStamp = TimeUtils.currentTimeMillis();
        double elapsedSinceLastXformEnd = (double)(xformEndStamp - this.myPrevTimestampMsec) / 1000.0;
        this.myPrevTimestampMsec = xformEndStamp;
        ++this.myTotalFramesProcessed;
        if (this.myTotalFramesProcessed % 100L == 0L) {
            long totalMsec = xformEndStamp - this.myFirstTimestampMsec;
            long avgFramePeriod = totalMsec / this.myTotalFramesProcessed;
            long lastIntervalMsec = xformEndStamp - this.myLastKeyframeTimestampMsec;
            long recentAvgFramePeriod = lastIntervalMsec / 100L;
            theLogger.info("After " + this.myTotalFramesProcessed + " frames, average motion frame msec=" + avgFramePeriod + ", last 100 frames averaged " + recentAvgFramePeriod);
            this.myLastKeyframeTimestampMsec = xformEndStamp;
        }
        double xformElapsedSec = (double)(xformEndStamp - xformStartStamp) / 1000.0;
        theLogger.trace("*************************** Finished transform at: " + xformEndStamp + ", xformElapsedSec=" + xformElapsedSec + ", time since last frameStamp=" + elapsedSinceLastXformEnd);
        return nextP;
    }

    public void setupTestMotionJobs(AnimoidConfig aconf, JobSpaceStub jobSpace) {
        this.theTestBlinkJob = new BlinkJob(aconf);
        this.registerMotionJob(this.theTestBlinkJob);
        jobSpace.postManualJob((JobStub)this.theTestBlinkJob);
        this.theTestVisemeJob = new VisemeJob(aconf, this.getNominalSecPerFrame());
        this.registerMotionJob(this.theTestVisemeJob);
        jobSpace.postManualJob((JobStub)this.theTestVisemeJob);
    }

    @Override
    public synchronized Frame estimatePositionAtMoment(long tstampMsec) {
        if (this.myPrevNominalVel == null) {
            return this.myPrevOutputPosFrame;
        }
        double deltaTsec = (double)(tstampMsec - this.myPrevTimestampMsec) / 1000.0;
        if (deltaTsec >= 0.0) {
            double servoFrameSmoothing = this.getFrameDurationSmoothingFactor();
            double servoFrameSpaceTsec = this.getNominalSecPerFrame() * servoFrameSmoothing;
            double motionFractionComplete = deltaTsec / servoFrameSpaceTsec;
            if (motionFractionComplete > 1.0) {
                theLogger.trace("Cannot estimate position after motion complete, momentTS=" + tstampMsec + ", prevFrameTS=" + this.myPrevTimestampMsec);
                return this.myPrevOutputPosFrame;
            }
            double reverseMotionFraction = 1.0 - motionFractionComplete;
            Frame deltaP = this.myPrevNominalVel.integrate(-1.0 * reverseMotionFraction * this.getNominalSecPerFrame());
            Frame posEst = this.myPrevOutputPosFrame.copy();
            posEst.addDeltaFrame(deltaP);
            return posEst;
        }
        theLogger.trace("Cannot estimate position before motion started, momentTS=" + tstampMsec + ", prevFrameTS=" + this.myPrevTimestampMsec);
        return this.myPrevOutputPosFrame;
    }

    @Override
    public synchronized Frame estimateVelocityAtMoment(long tstampMsec) {
        return this.myPrevNominalVel;
    }

    @Override
    public Frame estimatePositionRoughly() {
        return this.myPrevOutputPosFrame;
    }

    public String getContentSummaryString() {
        return "Later";
    }

    public String getTypeString() {
        return "BlenderJob";
    }

    @Override
    public Frame estimatePositionNow(boolean enhancedAccuracy) {
        Frame jointPosSnap = null;
        if (enhancedAccuracy) {
            long nowMsec = TimeUtils.currentTimeMillis();
            jointPosSnap = this.estimatePositionAtMoment(nowMsec);
        } else {
            jointPosSnap = this.estimatePositionRoughly();
        }
        return jointPosSnap;
    }
}

