/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.job;

import java.util.HashSet;
import java.util.Set;
import org.cogchar.animoid.calc.blend.SlopeBlendFuncs;
import org.cogchar.animoid.job.MotionJob;
import org.cogchar.api.animoid.config.bonus.AnimoidConfig;
import org.cogchar.api.animoid.protocol.Animation;
import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.JPARFrame;
import org.cogchar.api.animoid.protocol.JPRRFrame;
import org.cogchar.api.animoid.protocol.JVFrame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.zzz.platform.stub.JobStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationExecJob
extends MotionJob {
    private static Logger theLogger = LoggerFactory.getLogger((String)AnimationExecJob.class.getName());
    private transient Animation myAnimation;
    private int myCurrentFrameIndex;
    private transient Set<Joint> myCachedUsedJointSet;
    private String myGestureName;
    private boolean myOverrideCautionFlag = false;
    private double myRashAllowanceMultiplier;
    private double myRashBonusAllowance;

    public AnimationExecJob(AnimoidConfig aconf, Animation a, String gestureName, double rashAllowanceMultiplier, double rashBonusAllowance) {
        super(aconf);
        this.myAnimation = a;
        this.myCurrentFrameIndex = 0;
        this.myGestureName = gestureName;
        this.myRashAllowanceMultiplier = rashAllowanceMultiplier;
        this.myRashBonusAllowance = rashBonusAllowance;
    }

    public void setOverrideCautionFlag(boolean flagVal) {
        this.myOverrideCautionFlag = flagVal;
    }

    public Animation getAnimation() {
        return this.myAnimation;
    }

    public String getGestureName() {
        return this.myGestureName;
    }

    public String getScriptName() {
        return this.myAnimation.getName();
    }

    public boolean hasMoreFrames() {
        return this.myCurrentFrameIndex < this.myAnimation.getFrameCount();
    }

    public double getFractionComplete() {
        return (double)this.myCurrentFrameIndex / (double)this.myAnimation.getFrameCount();
    }

    public String getTypeString() {
        return "AnimationExecJob";
    }

    public String getContentSummaryString() {
        return "scriptName=" + this.myAnimation.getName() + ", gestureName=" + this.myGestureName + ", frameCount=" + this.myAnimation.getFrameCount() + ", fractionComplete=" + this.getFractionComplete() + ", rashAllowanceMult=" + this.myRashAllowanceMultiplier + ", rashBonusAllowance=" + this.myRashBonusAllowance + "]";
    }

    public Set<Joint> getUsedJoints() {
        if (this.myCachedUsedJointSet == null) {
            this.myCachedUsedJointSet = this.myAnimation.getUsedJointSet();
        }
        return this.myCachedUsedJointSet;
    }

    @Override
    public JVFrame contributeVelFrame(Frame prevPosAbsRomFrame, JVFrame prevVelRomFrame, Set<Joint> cautionJoints) {
        if (!this.hasMoreFrames()) {
            return new JVFrame();
        }
        if (this.myOverrideCautionFlag) {
            cautionJoints = new HashSet<Joint>();
        }
        JVFrame rashVelSubframe = this.getVelSubframeForRashJoints(prevPosAbsRomFrame, cautionJoints);
        JVFrame cautVelSubframe = this.getVelSubframeForCautionJoints(cautionJoints);
        JVFrame completeVelFrame = JVFrame.sumJVFrames(rashVelSubframe, cautVelSubframe);
        ++this.myCurrentFrameIndex;
        if (!this.hasMoreFrames()) {
            theLogger.info("AnimationExecJob completed!");
            this.setStatus(JobStub.Status.COMPLETED);
        }
        return JVFrame.makeFrom(completeVelFrame);
    }

    protected JVFrame getVelSubframeForRashJoints(Frame prevPosAbsRomFrame, Set<Joint> cautionJoints) {
        JVFrame relVelSubframe = null;
        HashSet<Joint> absoluteJoints = this.getAbsoluteJointsForCautionContext(cautionJoints);
        if (this.myCurrentFrameIndex != 0) {
            JPRRFrame goalDeltaFrame = this.getCurrentGoalDeltaSubframe(absoluteJoints);
            JPARFrame goalAbsFrame = this.getUnrampedPositionTargetsOnAbsoluteJoints(absoluteJoints);
            Frame ppAbsSubframe = prevPosAbsRomFrame.getSubframe(absoluteJoints, false);
            JPARFrame prevPosJPARF = JPARFrame.makeFrom(ppAbsSubframe);
            JPRRFrame naiveDeltaFrame = prevPosJPARF.computeRelFrame(goalAbsFrame);
            double goalAllowanceCoeff = this.myRashAllowanceMultiplier;
            double fixedAllowance = this.myRashBonusAllowance;
            JPRRFrame actualDeltaFrame = SlopeBlendFuncs.computeActualDeltaFrame(naiveDeltaFrame, goalDeltaFrame, goalAllowanceCoeff, fixedAllowance);
            double secPerFrame = this.getAnimoidConfig().getSecondsPerFrame();
            relVelSubframe = actualDeltaFrame.makeVelFrame(secPerFrame);
        }
        return JVFrame.makeFrom(relVelSubframe);
    }

    protected JVFrame getVelSubframeForCautionJoints(Set<Joint> cautionJoints) {
        JVFrame relVelSubframe = null;
        HashSet<Joint> usedCautiousJoints = new HashSet<Joint>(cautionJoints);
        usedCautiousJoints.retainAll(this.getUsedJoints());
        if (this.myCurrentFrameIndex != 0) {
            JPRRFrame goalDeltaSubframe = this.getCurrentGoalDeltaSubframe(usedCautiousJoints);
            double secPerFrame = this.getAnimoidConfig().getSecondsPerFrame();
            relVelSubframe = goalDeltaSubframe.makeVelFrame(secPerFrame);
        }
        return JVFrame.makeFrom(relVelSubframe);
    }

    protected JPRRFrame getCurrentGoalDeltaSubframe(Set<Joint> joints) {
        Frame goalDeltaSubframe = null;
        if (this.myCurrentFrameIndex != 0) {
            goalDeltaSubframe = this.myAnimation.getPartialFrameInCoordinateSystem(this.myCurrentFrameIndex, joints, JointStateCoordinateType.FLOAT_REL_RANGE_OF_MOTION);
        }
        return JPRRFrame.make(goalDeltaSubframe);
    }

    protected HashSet<Joint> getAbsoluteJointsForCautionContext(Set<Joint> cautionJoints) {
        HashSet<Joint> absoluteJoints = new HashSet<Joint>(this.getUsedJoints());
        absoluteJoints.removeAll(cautionJoints);
        return absoluteJoints;
    }

    protected JPARFrame getUnrampedPositionTargetsOnAbsoluteJoints(Set<Joint> absoluteJoints) {
        if (!this.hasMoreFrames()) {
            return new JPARFrame();
        }
        Frame targetAbsSubframe = this.myAnimation.getPartialFrameInCoordinateSystem(this.myCurrentFrameIndex, absoluteJoints, JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
        return JPARFrame.makeFrom(targetAbsSubframe);
    }

    public Frame takeFrameAndAdvance() {
        Frame currentFrame = null;
        if (this.hasMoreFrames()) {
            currentFrame = this.myAnimation.getFrameAt(this.myCurrentFrameIndex++);
        }
        if (!this.hasMoreFrames()) {
            theLogger.info("AnimationExecJob completed!");
            this.setStatus(JobStub.Status.COMPLETED);
        }
        return currentFrame;
    }
}

