/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.optimize;

import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.optimize.ParameterVector;
import org.cogchar.animoid.calc.optimize.ParametricJointTrajectory;

public class MultiStepPJT
extends ParametricJointTrajectory {
    public int myStepCount;
    private ParameterVector myLevelPV;
    private ParameterVector myDurationPV;

    public MultiStepPJT(NumberFactory nf) {
        this.myLevelPV = new ParameterVector(nf);
        this.myDurationPV = new ParameterVector(nf);
    }

    public void setStepCount(int numSteps) {
        this.myStepCount = numSteps;
        this.myLevelPV.setLength(numSteps);
        this.myDurationPV.setLength(numSteps);
    }

    public ParameterVector getDurationPV() {
        return this.myDurationPV;
    }

    public void setDurationPV(ParameterVector durPV) {
        this.myDurationPV = durPV;
    }

    public ParameterVector getLevelPV() {
        return this.myLevelPV;
    }

    public void incrementBoundaryPenalty(Dimension d, int idx, double penalty) {
    }

    public void fixDurationsAndAssessPenalties(double minDur, double maxDur) {
    }

    public int writeToArray(double[] array, int arrayStartIdx, boolean writeAbbrevDurations) {
        this.myLevelPV.writeValuesToArray(array, arrayStartIdx, 0, this.myStepCount);
        if (writeAbbrevDurations) {
            this.myDurationPV.writeValuesToArray(array, arrayStartIdx + this.myStepCount, 1, this.myStepCount - 2);
            return 2 * this.myStepCount - 2;
        }
        return this.myStepCount;
    }

    public int readFromArray(double[] array, int arrayStartIdx, boolean readAbbrevDurations) {
        this.myLevelPV.readValuesFromArray(array, arrayStartIdx, 0, this.myStepCount);
        if (readAbbrevDurations) {
            this.myDurationPV.readValuesFromArray(array, arrayStartIdx + this.myStepCount, 1, this.myStepCount - 2);
            return 2 * this.myStepCount - 2;
        }
        return this.myStepCount;
    }

    public String toString() {
        return "MultiStepPJT[stepCount=" + this.myStepCount + ", durationPV=" + this.myDurationPV + ", levelPV=" + this.myLevelPV + "]";
    }

    public static enum Dimension {
        LEVEL,
        DURATION;

    }
}

