/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curvematrix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.curve.ConstAccelCurve;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveMatrix;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveSequence;
import org.cogchar.animoid.calc.curvematrix.SDCACM_Interval;
import org.cogchar.animoid.calc.optimize.ParameterVector;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.number.Real;

public class SharedDurationCACM<RN extends Number<RN>>
extends ConstAccelCurveMatrix<RN> {
    protected List<SDCACM_Interval> myIntervals = new ArrayList<SDCACM_Interval>();

    public SharedDurationCACM(NumberFactory<RN> numFact) {
        super(numFact);
    }

    public SDCACM_Interval appendInterval() {
        int idx = this.myIntervals.size();
        String nameSuffix = "" + idx + 1;
        SDCACM_Interval interval = new SDCACM_Interval(idx, nameSuffix);
        Variable toffVar = interval.getTimeOffsetVariable();
        Set curves = this.addAndCollectOneCurvePerSequence(toffVar, nameSuffix);
        interval.setCurveSet(curves);
        this.myIntervals.add(interval);
        return interval;
    }

    private Set<ConstAccelCurve> addAndCollectOneCurvePerSequence(Variable<Real> timeOffsetVar, String nameSuffix) {
        HashSet<ConstAccelCurve> curves = new HashSet<ConstAccelCurve>();
        for (ConstAccelCurveSequence<Real> constAccelCurveSequence : this.getSequences()) {
            String seqName = constAccelCurveSequence.getName();
            String curveSymbolSuffix = seqName + "_" + nameSuffix;
            ConstAccelCurve<Real> curve = new ConstAccelCurve<Real>(curveSymbolSuffix, timeOffsetVar, this.myNumberFactory);
            constAccelCurveSequence.addStepCurve(curve);
            curves.add(curve);
        }
        return curves;
    }

    public void setDurations(ParameterVector durPV) {
        for (ConstAccelCurveSequence seq : this.getSequences()) {
            seq.setDurationParams(durPV);
        }
    }

    public List<SDCACM_Interval> getIntervals() {
        return this.myIntervals;
    }
}

