/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curvematrix;

import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveMatrix;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveSequence;
import org.cogchar.animoid.calc.curvematrix.RampingFramedCurveSeq;
import org.jscience.mathematics.number.Number;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RampingFramedCACM<RN extends Number<RN>>
extends ConstAccelCurveMatrix<RN> {
    private static Logger theLogger = LoggerFactory.getLogger((String)RampingFramedCACM.class.getName());

    public RampingFramedCACM(NumberFactory<RN> numFact) {
        super(numFact);
    }

    public RampingFramedCurveSeq makeSequence(String name) {
        RampingFramedCurveSeq cs = new RampingFramedCurveSeq(name, this.myNumberFactory);
        this.addSequence(cs);
        return cs;
    }

    public static int minFramesToChangeSpeed(double totalDeltaVelRequired, double maxDeltaVelPerFrame) {
        if (totalDeltaVelRequired < 0.0) {
            throw new RuntimeException("Negative deltaVelReq: " + totalDeltaVelRequired);
        }
        if (maxDeltaVelPerFrame < 0.0) {
            throw new RuntimeException("Negative maxDeltaVel: " + maxDeltaVelPerFrame);
        }
        double ratio = totalDeltaVelRequired / maxDeltaVelPerFrame;
        return (int)Math.ceil(ratio);
    }

    public int minFramesToStopAllSeqsFromInitVel() {
        int maxMin = 0;
        for (ConstAccelCurveSequence cacs : this.getSequences()) {
            RampingFramedCurveSeq cs = (RampingFramedCurveSeq)cacs;
            int csMinBrakeFrames = cs.minFramesToStopFromInitVel();
            if (csMinBrakeFrames <= maxMin) continue;
            maxMin = csMinBrakeFrames;
        }
        return maxMin;
    }
}

