/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curvematrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appdapter.bind.math.jscience.function.BumpUF;
import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.curve.ConstAccelCurve;
import org.cogchar.animoid.calc.curve.ConstAccelCurveStateVarSymbol;
import org.cogchar.animoid.calc.optimize.ParameterVector;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.vector.Vector;

public class ConstAccelCurveSequence<RN extends Number<RN>> {
    private String myName;
    private List<ConstAccelCurve<RN>> myStepCurves = new ArrayList<ConstAccelCurve<RN>>();
    private ParameterVector<RN> myDurationPV;
    private ParameterVector<RN> myAccelPV;
    private NumberFactory<RN> myNumberFactory;
    private boolean myDirtyFlag = true;
    public Map<Variable<RN>, StateVarParamPartials> myJacobianMap;

    public ConstAccelCurveSequence(String name, NumberFactory<RN> numberFactory) {
        this.myName = name;
        this.myNumberFactory = numberFactory;
    }

    public String getName() {
        return this.myName;
    }

    protected NumberFactory<RN> getNumberFactory() {
        return this.myNumberFactory;
    }

    public void addStepCurve(ConstAccelCurve<RN> nextCurve) {
        this.myStepCurves.add(nextCurve);
    }

    public ConstAccelCurve<RN> getStepCurve(int idx) {
        return this.myStepCurves.get(idx);
    }

    public ConstAccelCurve<RN> getFirstStepCurve() {
        return this.getStepCurve(0);
    }

    public int getStepCount() {
        return this.myStepCurves.size();
    }

    public void setAccelParams(ParameterVector<RN> accVec) {
        this.myDirtyFlag = true;
        int stepCount = this.getStepCount();
        if (accVec.getLength() != this.myStepCurves.size()) {
            throw new RuntimeException("Mismatched sizes for curveSeq=" + this + " and accel-vec=" + accVec);
        }
        this.myAccelPV = accVec;
    }

    private void syncAccelParams(ParameterVector accVec) {
        int stepCount = this.getStepCount();
        for (int idx = 0; idx < stepCount; ++idx) {
            double accelVal = accVec.getValue(idx);
            this.setAccelParam(idx, accelVal);
        }
    }

    public void setAccelParam(int curveIndex, double accelValue) {
        Number accelValueNum = this.myNumberFactory.makeNumberFromDouble(accelValue);
        this.setAccelParam(curveIndex, accelValueNum);
    }

    public void setAccelParam(int curveIndex, RN accelValueNum) {
        this.myDirtyFlag = true;
        ConstAccelCurve<RN> c = this.getStepCurve(curveIndex);
        c.setStateVarVal(ConstAccelCurveStateVarSymbol.CONST_ACCEL, accelValueNum);
    }

    public void setDurationParams(ParameterVector<RN> durVec) {
        this.myDirtyFlag = true;
        int stepCount = this.getStepCount();
        if (durVec.getLength() != stepCount) {
            throw new RuntimeException("Mismatched sizes for curveSeq=" + this + " and duration-vec=" + durVec);
        }
        this.myDurationPV = durVec;
    }

    public void setInitialConditions(RN initPos, RN initVel) {
        this.myDirtyFlag = true;
        ConstAccelCurve<RN> firstCurve = this.getFirstStepCurve();
        firstCurve.setStateVarVal(ConstAccelCurveStateVarSymbol.INIT_POS, initPos);
        firstCurve.setStateVarVal(ConstAccelCurveStateVarSymbol.INIT_VEL, initVel);
    }

    public RN getStepDuration(int idx) {
        return this.myDurationPV.getNumber(idx);
    }

    public RN getTotalDuration() {
        double durSum = this.myDurationPV.sumValues();
        return (RN)this.myNumberFactory.makeNumberFromDouble(durSum);
    }

    public void propagateEndpointConditions() {
        if (this.myDirtyFlag) {
            this.syncAccelParams(this.myAccelPV);
            int stepCount = this.getStepCount();
            for (int idx = 1; idx < stepCount; ++idx) {
                ConstAccelCurve<RN> curve = this.getStepCurve(idx);
                ConstAccelCurve<RN> prevCurve = this.getStepCurve(idx - 1);
                RN prevDurationNum = this.getStepDuration(idx - 1);
                prevCurve.setStateVarVal(ConstAccelCurveStateVarSymbol.TIME_OFFSET, prevDurationNum);
                RN prevEndPos = prevCurve.getPositionAtCurrentState();
                RN prevEndVel = prevCurve.getVelocityAtCurrentState();
                curve.setStateVarVal(ConstAccelCurveStateVarSymbol.INIT_POS, prevEndPos);
                curve.setStateVarVal(ConstAccelCurveStateVarSymbol.INIT_VEL, prevEndVel);
            }
            this.myDirtyFlag = false;
        }
    }

    protected Integer findStepIndexForTimeOffset(RN offset) {
        double sum = 0.0;
        if (this.myDurationPV == null) {
            return null;
        }
        Integer idx = this.myDurationPV.findIndexWithinImpliedSum(offset.doubleValue());
        return idx;
    }

    protected RN findOffsetWithinStep(int stepIdx, RN offsetFromSeqStart) {
        double prevSum = this.myDurationPV.sumLeadingValues(stepIdx);
        double localOffset = offsetFromSeqStart.doubleValue() - prevSum;
        return (RN)this.myNumberFactory.makeNumberFromDouble(localOffset);
    }

    public RN getAccelAtTime(RN timeOffset) {
        Integer stepIdx = this.findStepIndexForTimeOffset(timeOffset);
        if (stepIdx != null) {
            ConstAccelCurve<RN> curve = this.getStepCurve(stepIdx);
            return curve.getAccelAtCurrentState();
        }
        return null;
    }

    public RN getVelAtTime(RN timeOffset) {
        Integer stepIdx = this.findStepIndexForTimeOffset(timeOffset);
        if (stepIdx != null) {
            ConstAccelCurve<RN> curve = this.getStepCurve(stepIdx);
            RN stepOffset = this.findOffsetWithinStep(stepIdx, timeOffset);
            curve.setTimeOffset(stepOffset);
            return curve.getVelocityAtCurrentState();
        }
        return null;
    }

    public RN getPosAtTime(RN timeOffset) {
        Integer stepIdx = this.findStepIndexForTimeOffset(timeOffset);
        if (stepIdx != null) {
            ConstAccelCurve<RN> curve = this.getStepCurve(stepIdx);
            RN stepOffset = this.findOffsetWithinStep(stepIdx, timeOffset);
            curve.setTimeOffset(stepOffset);
            return curve.getPositionAtCurrentState();
        }
        return null;
    }

    public void appendMotionFrameDump(StringBuffer buf, RN timeOffset) {
        RN pos = this.getPosAtTime(timeOffset);
        RN vel = this.getVelAtTime(timeOffset);
        RN acc = this.getAccelAtTime(timeOffset);
        buf.append("t=").append(timeOffset).append(" x=").append(pos);
        buf.append(" v=").append(vel).append(" a=").append(acc);
    }

    public String dumpMotionPlan(int sampleCount, double lastSampleTime) {
        StringBuffer motionPlanBuf = new StringBuffer("CACS_plan[name=");
        motionPlanBuf.append(this.myName).append("\n");
        motionPlanBuf.append("durations=" + this.myDurationPV.toString() + "\n");
        motionPlanBuf.append("accelerts=" + this.myAccelPV.toString() + "\n");
        double sampleWidth = lastSampleTime / (double)(sampleCount - 1);
        for (int idx = 0; idx < sampleCount; ++idx) {
            double sampleTime = (double)idx * sampleWidth;
            Number sampleTimeRN = this.myNumberFactory.makeNumberFromDouble(sampleTime);
            this.appendMotionFrameDump(motionPlanBuf, sampleTimeRN);
            motionPlanBuf.append("\n");
        }
        motionPlanBuf.append("]");
        return motionPlanBuf.toString();
    }

    public Map<Variable<RN>, StateVarParamPartials> getJacobianValueMatrixMap(List<Variable<RN>> stateVars) {
        HashMap<Variable<RN>, StateVarParamPartials> jacobMap = new HashMap<Variable<RN>, StateVarParamPartials>();
        for (Variable<RN> sv : stateVars) {
            StateVarParamPartials svpp = new StateVarParamPartials();
            jacobMap.put(sv, svpp);
        }
        return jacobMap;
    }

    public BumpUF<RN, RN> getBumpFunction() {
        return new CACS_BumpUF();
    }

    public String toString() {
        double totalDur = this.getTotalDuration().doubleValue();
        return "ConstAccelCurveSeq[accelPV=" + this.myAccelPV + ", durPV=" + this.myDurationPV + ", motionPlan=" + this.dumpMotionPlan(10, totalDur) + "]";
    }

    class CACS_BumpUF
    implements BumpUF<RN, RN> {
        CACS_BumpUF() {
        }

        public RN getDerivativeAtInput(RN inputValue, int derivativeOrder) {
            if (derivativeOrder != 1) {
                throw new UnsupportedOperationException("Can't yet use derivatives other than 1st");
            }
            return ConstAccelCurveSequence.this.getVelAtTime(inputValue);
        }

        public RN getOutputForInput(RN inputValue) {
            return ConstAccelCurveSequence.this.getPosAtTime(inputValue);
        }

        public RN getSupportLowerBound() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public RN getSupportUpperBound() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public class StateVarParamPartials {
        public Vector<RN> partialsForDurations;
        public Vector<RN> partialsForAccels;
    }
}

