/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curvematrix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.appdapter.bind.math.jscience.number.NumberFactory;
import org.cogchar.animoid.calc.curve.ConstAccelCurveStateVarSymbol;
import org.cogchar.animoid.calc.curvematrix.ConstAccelCurveSequence;
import org.cogchar.animoid.calc.curvematrix.StateFrameMatrix;
import org.jscience.mathematics.number.Number;

public class ConstAccelCurveMatrix<RN extends Number<RN>> {
    protected Map<String, ConstAccelCurveSequence<RN>> mySequencesByName = new HashMap<String, ConstAccelCurveSequence<RN>>();
    protected List<ConstAccelCurveSequence<RN>> mySequences = new ArrayList<ConstAccelCurveSequence<RN>>();
    protected NumberFactory<RN> myNumberFactory;

    public ConstAccelCurveMatrix(NumberFactory<RN> numFact) {
        this.myNumberFactory = numFact;
    }

    protected void addSequence(ConstAccelCurveSequence<RN> seq) {
        String seqName = seq.getName();
        this.mySequencesByName.put(seqName, seq);
        this.mySequences.add(seq);
    }

    public ConstAccelCurveSequence<RN> addEmptySequenceForName(String name) {
        ConstAccelCurveSequence<RN> seq = new ConstAccelCurveSequence<RN>(name, this.myNumberFactory);
        this.addSequence(seq);
        return seq;
    }

    public void propagateEndpointConditions() {
        for (ConstAccelCurveSequence<RN> seq : this.getSequences()) {
            seq.propagateEndpointConditions();
        }
    }

    public List<ConstAccelCurveSequence<RN>> getSequences() {
        return this.mySequences;
    }

    public int getSequenceCount() {
        return this.mySequences.size();
    }

    public int getCurveCountPerSequence() {
        ConstAccelCurveSequence<RN> firstSeq = this.mySequences.get(0);
        return firstSeq.getStepCount();
    }

    public StateFrameMatrix<ConstAccelCurveStateVarSymbol, RN> getStateFrameMatrix() {
        return null;
    }

    public void absorbStateFrameMatrix(StateFrameMatrix<ConstAccelCurveStateVarSymbol, RN> matrix) {
    }

    public String dumpSamples(int sampleCount, double lastSampleTime) {
        StringBuffer dumpBuf = new StringBuffer();
        for (ConstAccelCurveSequence<RN> seq : this.getSequences()) {
            dumpBuf.append(seq.dumpMotionPlan(sampleCount, lastSampleTime));
        }
        return dumpBuf.toString();
    }

    public String toString() {
        return "ConstAccelCurveMatrix[seqByName=" + this.mySequencesByName + "]";
    }
}

