/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.calc.curve;

import java.util.ArrayList;
import java.util.List;
import org.appdapter.bind.math.jscience.function.SmoothUF;
import org.appdapter.bind.math.jscience.number.NumberFuncs;
import org.cogchar.animoid.calc.curve.ImmutableStateFrame;
import org.cogchar.animoid.calc.curve.PMC_StateVariable;
import org.cogchar.animoid.calc.curve.StateVariableSymbol;
import org.jscience.mathematics.function.Polynomial;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.number.Number;

public class PolynomialMotionCurve<StateVarSymbol extends StateVariableSymbol, RN extends Number<RN>> {
    protected Polynomial<RN> myCurvePoly;
    protected List<PMC_StateVariable<StateVarSymbol, RN>> myStateVars;
    protected String mySymbolSuffix;

    public PolynomialMotionCurve(String symbolSuffix) {
        this.mySymbolSuffix = symbolSuffix;
    }

    public void setCurvePoly(Polynomial c) {
        if (this.myCurvePoly != null) {
            throw new RuntimeException("Changing poly on a curve not yet supported!");
        }
        this.myCurvePoly = c;
    }

    public Polynomial<RN> getCurvePoly() {
        return this.myCurvePoly;
    }

    protected PMC_StateVariable getStateVariable(StateVarSymbol symbol) {
        int varIndex = symbol.getSymbolIndex();
        if (this.myStateVars == null) {
            int symCount = symbol.getSymbolBlockSize();
            this.myStateVars = new ArrayList<PMC_StateVariable<StateVarSymbol, RN>>(symCount);
            for (int i = 0; i < symCount; ++i) {
                this.myStateVars.add(null);
            }
        }
        if (this.myStateVars.get(varIndex) == null) {
            String fullName = symbol.getSymbolString() + this.mySymbolSuffix;
            PMC_StateVariable pmcsv = new PMC_StateVariable(symbol, fullName);
            this.myStateVars.set(varIndex, pmcsv);
        }
        return this.myStateVars.get(varIndex);
    }

    public void setStateVarVal(StateVarSymbol symbol, RN val) {
        this.getPolyVar(symbol).set(val);
    }

    public RN getStateVarVal(StateVarSymbol symbol) {
        return (RN)((Number)this.getPolyVar(symbol).get());
    }

    protected Variable<RN> getPolyVar(StateVarSymbol symbol) {
        PMC_StateVariable sv = this.getStateVariable(symbol);
        return sv.getPolyVar();
    }

    protected void useExistingPolyVar(StateVarSymbol symbol, Variable<RN> pvar) {
        PMC_StateVariable sv = this.getStateVariable(symbol);
        sv.setPolyVar(pvar);
    }

    public String getFullSymbolStringForStateVar(StateVarSymbol svs) {
        return svs.getSymbolString() + this.mySymbolSuffix;
    }

    public void readStateFromFrame(ImmutableStateFrame frame) {
    }

    public ImmutableStateFrame getStateFrame() {
        return null;
    }

    public ImmutableStateFrame getDerivativeStateFrame() {
        return null;
    }

    protected Polynomial<RN> getDerivPolyForStateVarSymbol(StateVarSymbol symbol) {
        PMC_StateVariable sv = this.getStateVariable(symbol);
        return sv.getDerivativePoly(this.myCurvePoly);
    }

    public RN evalCurvePolyAtCurrentState() {
        return (RN)NumberFuncs.evalPoly(this.getCurvePoly());
    }

    public RN evalDerivPolyAtCurrentState(StateVarSymbol symbol) {
        Polynomial<RN> derivPoly = this.getDerivPolyForStateVarSymbol(symbol);
        return (RN)NumberFuncs.evalPoly(derivPoly);
    }

    public Polynomial<RN> makeOutputDerivativeNormPoly(int derivativeOrder, RN centerPoint, int power, RN coeff) {
        return null;
    }

    public SmoothUF<RN, RN> getFiniteTimeCurve() {
        return null;
    }
}

