/*
 * Decompiled with CFR 0.152.
 */
package org.cogchar.animoid.broker;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.cogchar.animoid.broker.AnimationBuilder;
import org.cogchar.animoid.broker.Animator;
import org.cogchar.animoid.broker.AnimoidCueSpaceStub;
import org.cogchar.animoid.broker.MotionController;
import org.cogchar.animoid.calc.estimate.PositionEstimator;
import org.cogchar.animoid.job.AnimationExecJob;
import org.cogchar.animoid.job.BlenderJob;
import org.cogchar.animoid.job.VisemeJob;
import org.cogchar.api.animoid.config.bonus.AnimoidConfig;
import org.cogchar.api.animoid.config.bonus.ServoChannelConfig;
import org.cogchar.api.animoid.config.bonus.VisemeConfig;
import org.cogchar.api.animoid.protocol.Animation;
import org.cogchar.api.animoid.protocol.Device;
import org.cogchar.api.animoid.protocol.Frame;
import org.cogchar.api.animoid.protocol.Joint;
import org.cogchar.api.animoid.protocol.JointPosition;
import org.cogchar.api.animoid.protocol.JointPositionAROM;
import org.cogchar.api.animoid.protocol.JointStateCoordinateType;
import org.cogchar.api.animoid.protocol.Library;
import org.cogchar.api.animoid.protocol.Robot;
import org.cogchar.xml.animoid.AnimoidConfigLoader;
import org.cogchar.zzz.platform.stub.JobSpaceStub;
import org.cogchar.zzz.platform.stub.JobStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimoidFacade
implements Animator {
    private static Logger theLogger = LoggerFactory.getLogger((String)AnimoidFacade.class.getName());
    protected JobSpaceStub myJobSpace;
    protected AnimoidCueSpaceStub myCueSpace;
    protected AnimoidConfig myAnimoidConfig;
    protected MotionController myMotionController;
    protected BlenderJob myBlenderJob;
    private Robot myMainRobot;
    private Device myMainDevice;
    private Library myAnimationLibrary;
    private VisemeConfig myVisemeConfig;
    private ServoChannelConfig[] myServoConfigSparseArray;
    private boolean myAnimationsEnabledFlag = false;
    public static final String T_VISEMES_ENABLED = "T_VISEMES_ENABLED";
    public static final String T_VISEMES_DISABLED = "T_VISEMES_DISABLED";
    public static final String T_SCRIPTED_ENABLED = "T_ALL_ANIMS_ENABLED";
    public static final String T_SCRIPTED_DISABLED = "T_ALL_ANIMS_DISABLED";
    public static final String T_ATTENTION_ENABLED = "T_ATTENTION_ENABLED";
    public static final String T_ATTENTION_DISABLED = "T_ATTENTION_DISABLED";

    public AnimoidFacade(String servoConfigPath, URL animoidConfigURL, String visemeConfigPath, Integer msecPerFrame, double frameDurationSmoothingFactor) throws Throwable {
        this.loadServoChannelConfigs(servoConfigPath);
        theLogger.info("Reading animoid config from URL: " + animoidConfigURL);
        this.myAnimoidConfig = AnimoidConfigLoader.loadAnimoidConfig(animoidConfigURL, this.myMainRobot, msecPerFrame, frameDurationSmoothingFactor);
        this.loadVisemeConfig(visemeConfigPath);
    }

    public void setJobSpace(JobSpaceStub jobSpace) {
        this.myJobSpace = jobSpace;
    }

    public void setCueSpace(AnimoidCueSpaceStub cueSpace) {
        this.myCueSpace = cueSpace;
    }

    public void setAnimationLibrary(Library lib) {
        this.myAnimationLibrary = lib;
    }

    private void loadServoChannelConfigs(String servoConfigPath) throws Throwable {
        theLogger.info("Reading servo config file from: " + servoConfigPath);
        this.myServoConfigSparseArray = ServoChannelConfig.readServoConfigFile(servoConfigPath, 32);
        this.initUsingServoConfigSparseArray(this.myServoConfigSparseArray);
    }

    private void loadVisemeConfig(String visemeConfigFilename) throws Throwable {
        if (visemeConfigFilename != null) {
            this.myVisemeConfig = VisemeConfig.buildVisemeConfig(visemeConfigFilename, this.myServoConfigSparseArray, this.myMainRobot);
        } else {
            theLogger.warn("VisemeConfigFilename is null - skipping viseme config");
        }
    }

    public void setupBlenderJob() {
        this.myBlenderJob = new BlenderJob(this.myAnimoidConfig);
        this.myJobSpace.postManualJob((JobStub)this.myBlenderJob);
    }

    public void setTestMotionJobs() {
        this.myBlenderJob.setupTestMotionJobs(this.myAnimoidConfig, this.myJobSpace);
        this.myBlenderJob.theTestVisemeJob.setCurrentTargetPosFrame(this.getVisemeFrameInAbsROM(0));
        this.myBlenderJob.theTestVisemeJob.setNextTargetPosFrame(this.getVisemeFrameInAbsROM(0));
    }

    @Override
    public AnimoidConfig getAnimoidConfig() {
        return this.myAnimoidConfig;
    }

    public Double getSecondsPerFrame() {
        return this.getAnimoidConfig().getSecondsPerFrame();
    }

    @Override
    public PositionEstimator getPositionEstimator() {
        return this.myBlenderJob;
    }

    public void setMotionController(MotionController mc) {
        this.myMotionController = mc;
    }

    public MotionController getMotionController() {
        return this.myMotionController;
    }

    private AnimationExecJob startAnimationJob(Animation a, String gestureName, double rashAllowMult, double rashBonusAllow) {
        AnimationExecJob aej = new AnimationExecJob(this.myAnimoidConfig, a, gestureName, rashAllowMult, rashBonusAllow);
        aej.scheduleToStartNow();
        aej.click();
        this.myBlenderJob.registerMotionJob(aej);
        this.myJobSpace.postManualJob((JobStub)aej);
        return aej;
    }

    @Override
    public void playAnimation(String animName, String gestureName, double rashAllowMult, double rashBonusAllow) {
        if (!this.myAnimationsEnabledFlag) {
            theLogger.info("Ignoring request to play anim/gesture[" + animName + "/" + gestureName + "] because animations are disabled");
            return;
        }
        Animation a = this.getAnimationLibrary().getAnimationForName(animName);
        if (a != null) {
            this.startAnimationJob(a, gestureName, rashAllowMult, rashBonusAllow);
        } else {
            theLogger.warn("Can't find animation named: " + animName + ", ignoring play request");
        }
    }

    public void initUsingServoConfigSparseArray(ServoChannelConfig[] servoConfigSparseArray) {
        this.myServoConfigSparseArray = servoConfigSparseArray;
        this.myMainRobot = new Robot("MAIN_ROBOT");
        this.myMainDevice = new Device("MAIN_DEVICE", Device.Type.SSC32_V20);
        for (int channelIDX = 0; channelIDX < servoConfigSparseArray.length; ++channelIDX) {
            ServoChannelConfig scc = servoConfigSparseArray[channelIDX];
            if (scc == null) continue;
            String deviceChannelID = "" + channelIDX;
            int logicalChannelNum = scc.logicalChannel;
            String jointName = scc.getMuscleJoint().name();
            Joint j = new Joint(this.myMainDevice, this.myMainRobot, deviceChannelID, jointName);
            j.oldLogicalJointNumber = logicalChannelNum;
            j.oldMinServoPos = scc.minPos;
            j.oldDefServoPos = scc.defaultPos;
            j.oldMaxServoPos = scc.maxPos;
            j.oldInvertedFlag = scc.inverted;
            this.myMainRobot.registerJoint(j);
            this.myMainDevice.registerJoint(j);
        }
    }

    public Robot getMainRobot() {
        return this.myMainRobot;
    }

    public Device getMainDevice() {
        return this.myMainDevice;
    }

    public Library getAnimationLibrary() {
        return this.myAnimationLibrary;
    }

    public Frame<JointPositionAROM> getVisemeFrameInAbsROM(int visemeNumber) {
        Frame<JointPositionAROM> result = null;
        if (this.myVisemeConfig != null) {
            result = this.myVisemeConfig.getFrameForVisemeNumber(visemeNumber);
        }
        return result;
    }

    public ServoChannelConfig[] getServoChannelConfigSparseArray() {
        return this.myServoConfigSparseArray;
    }

    public VisemeJob getVisemeJob() {
        return this.myBlenderJob.theTestVisemeJob;
    }

    public VisemeConfig getVisemeConfig() {
        return this.myVisemeConfig;
    }

    public void suggestViseme(int curViseme, int duration, byte flags, int nextViseme) {
        theLogger.trace("Suggesting a viseme: curViseme-" + curViseme + ", nextViseme-" + nextViseme + ", durration-" + duration);
        VisemeJob vj = this.myBlenderJob.theTestVisemeJob;
        vj.setCurrentVisemeNumber(curViseme);
        vj.setNextVisemeNumber(nextViseme);
        vj.setDurationMillisec(duration);
        Frame<JointPositionAROM> currentFrame = this.getVisemeFrameInAbsROM(curViseme);
        Frame<JointPositionAROM> nextFrame = this.getVisemeFrameInAbsROM(nextViseme);
        vj.setCurrentTargetPosFrame(currentFrame);
        vj.setNextTargetPosFrame(nextFrame);
        vj.markUpdated();
    }

    public void suggestAnimationScriptName(String scriptName, String gestureName, double rashAllowMult, double rashBonusAllow) {
        this.playAnimation(scriptName, gestureName, rashAllowMult, rashBonusAllow);
    }

    public Frame transformFrame(Frame currPosAbsRomFrame) {
        if (this.myBlenderJob != null) {
            return this.myBlenderJob.transformFrame(currPosAbsRomFrame);
        }
        return currPosAbsRomFrame;
    }

    public JointPosition getJointPositionAbsROM(Integer oldLogicalJointNumber, boolean now) {
        Frame posEstimate = this.myBlenderJob.estimatePositionNow(now);
        Object jp = posEstimate.getJointPositionForOldLogicalJointNumber(oldLogicalJointNumber);
        return ((JointPosition)jp).convertToCooordinateType(JointStateCoordinateType.FLOAT_ABS_RANGE_OF_MOTION);
    }

    public void enableVisemes() {
        theLogger.info("Enabling visemes");
        VisemeJob vj = this.getVisemeJob();
        if (vj != null) {
            vj.enableMotion();
        }
        this.myCueSpace.addThoughtCueForName(T_VISEMES_ENABLED, 1.0);
    }

    public void disableVisemes() {
        theLogger.info("Disabling visemes");
        VisemeJob vj = this.getVisemeJob();
        if (vj != null) {
            vj.disableMotion();
        }
        this.myCueSpace.clearMatchingNamedCues(T_VISEMES_ENABLED);
        this.myCueSpace.addThoughtCueForName(T_VISEMES_DISABLED, 1.0);
    }

    public void enableScriptedAnimations() {
        theLogger.info("Enabling scripted animations");
        this.myAnimationsEnabledFlag = true;
        this.myCueSpace.clearMatchingNamedCues(T_SCRIPTED_DISABLED);
        this.myCueSpace.addThoughtCueForName(T_SCRIPTED_ENABLED, 1.0);
    }

    public void disableScriptedAnimations() {
        theLogger.info("Disabling scripted animations");
        this.myAnimationsEnabledFlag = false;
        this.myCueSpace.clearMatchingNamedCues(T_SCRIPTED_ENABLED);
        this.myCueSpace.addThoughtCueForName(T_SCRIPTED_DISABLED, 1.0);
    }

    public void killAllAnimations() {
        theLogger.info("Killing all animations via thalamus (not Blender)");
        this.myJobSpace.terminateAndClearJobsInClass(AnimationExecJob.class);
    }

    public void forceServosToCenter() {
        theLogger.info("Forcibly playing recentering animation");
        AnimoidConfig ac = this.getAnimoidConfig();
        double secPerFrame = ac.getSecondsPerFrame();
        Animation anim = AnimationBuilder.makeRobotCenteringAnimation(this.myMainRobot, "RECENTER", 40, secPerFrame);
        AnimationExecJob aej = this.startAnimationJob(anim, "FORCE_RECENTER", 1.2, 0.025);
        aej.setOverrideCautionFlag(true);
    }

    public Map<Integer, Integer> getRoboardServoMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (ServoChannelConfig scc : this.myServoConfigSparseArray) {
            if (scc == null || scc.roboardChannel == -1) continue;
            map.put(scc.logicalChannel, scc.roboardChannel);
        }
        return map;
    }
}

