/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Objects;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.DfsReferralData;
import jcifs.NetbiosAddress;
import jcifs.RuntimeCIFSException;
import jcifs.SmbResourceLocator;
import jcifs.internal.util.StringUtil;
import jcifs.netbios.UniAddress;
import jcifs.smb.SmbResourceLocatorInternal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbResourceLocatorImpl
implements SmbResourceLocatorInternal,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(SmbResourceLocatorImpl.class);
    private final URL url;
    private DfsReferralData dfsReferral = null;
    private String unc;
    private String canon;
    private String share;
    private Address[] addresses;
    private int addressIndex;
    private int type;
    private CIFSContext ctx;

    public SmbResourceLocatorImpl(CIFSContext ctx, URL u) {
        this.ctx = ctx;
        this.url = u;
    }

    protected SmbResourceLocatorImpl clone() {
        SmbResourceLocatorImpl loc = new SmbResourceLocatorImpl(this.ctx, this.url);
        loc.canon = this.canon;
        loc.share = this.share;
        loc.dfsReferral = this.dfsReferral;
        loc.unc = this.unc;
        if (this.addresses != null) {
            loc.addresses = new UniAddress[this.addresses.length];
            System.arraycopy(this.addresses, 0, loc.addresses, 0, this.addresses.length);
        }
        loc.addressIndex = this.addressIndex;
        loc.type = this.type;
        return loc;
    }

    void resolveInContext(SmbResourceLocator context, String name) {
        String shr = context.getShare();
        if (shr != null) {
            this.dfsReferral = context.getDfsReferral();
        }
        int last = name.length() - 1;
        boolean trailingSlash = false;
        if (last >= 0 && name.charAt(last) == '/') {
            trailingSlash = true;
            name = name.substring(0, last);
        }
        if (shr == null) {
            String[] nameParts = name.split("/");
            int pos = 0;
            if (context.getServer() == null) {
                pos = 1;
            }
            if (nameParts.length > pos) {
                this.share = nameParts[pos++];
            }
            if (nameParts.length > pos) {
                CharSequence[] remainParts = new String[nameParts.length - pos];
                System.arraycopy(nameParts, pos, remainParts, 0, nameParts.length - pos);
                this.unc = "\\" + StringUtil.join("\\", remainParts) + (trailingSlash ? "\\" : "");
                this.canon = "/" + this.share + "/" + StringUtil.join("/", remainParts) + (trailingSlash ? "/" : "");
            } else {
                this.unc = "\\";
                this.canon = this.share != null ? "/" + this.share + (trailingSlash ? "/" : "") : "/";
            }
        } else {
            String uncPath = context.getUNCPath();
            if (uncPath.equals("\\")) {
                this.unc = '\\' + name.replace('/', '\\') + (trailingSlash ? "\\" : "");
                this.canon = context.getURLPath() + name + (trailingSlash ? "/" : "");
                this.share = shr;
            } else {
                this.unc = uncPath + name.replace('/', '\\') + (trailingSlash ? "\\" : "");
                this.canon = context.getURLPath() + name + (trailingSlash ? "/" : "");
                this.share = shr;
            }
        }
    }

    @Override
    public DfsReferralData getDfsReferral() {
        return this.dfsReferral;
    }

    @Override
    public String getName() {
        String urlpath = this.getURLPath();
        String shr = this.getShare();
        if (urlpath.length() > 1) {
            int i = urlpath.length() - 2;
            while (urlpath.charAt(i) != '/') {
                --i;
            }
            return urlpath.substring(i + 1);
        }
        if (shr != null) {
            return shr + '/';
        }
        if (this.url.getHost().length() > 0) {
            return this.url.getHost() + '/';
        }
        return "smb://";
    }

    @Override
    public String getParent() {
        String str = this.url.getAuthority();
        if (str != null && !str.isEmpty()) {
            StringBuffer sb = new StringBuffer("smb://");
            sb.append(str);
            String urlpath = this.getURLPath();
            if (urlpath.length() > 1) {
                sb.append(urlpath);
            } else {
                sb.append('/');
            }
            str = sb.toString();
            int i = str.length() - 2;
            while (str.charAt(i) != '/') {
                --i;
            }
            return str.substring(0, i + 1);
        }
        return "smb://";
    }

    @Override
    public String getPath() {
        return this.url.toString();
    }

    @Override
    public String getCanonicalURL() {
        String str = this.url.getAuthority();
        if (str != null && !str.isEmpty()) {
            return "smb://" + this.url.getAuthority() + this.getURLPath();
        }
        return "smb://";
    }

    @Override
    public String getUNCPath() {
        if (this.unc == null) {
            this.canonicalizePath();
        }
        return this.unc;
    }

    @Override
    public String getURLPath() {
        if (this.unc == null) {
            this.canonicalizePath();
        }
        return this.canon;
    }

    @Override
    public String getShare() {
        if (this.unc == null) {
            this.canonicalizePath();
        }
        return this.share;
    }

    @Override
    public String getServerWithDfs() {
        if (this.dfsReferral != null) {
            return this.dfsReferral.getServer();
        }
        return this.getServer();
    }

    @Override
    public String getServer() {
        String str = this.url.getHost();
        if (str.length() == 0) {
            return null;
        }
        return str;
    }

    @Override
    public String getDfsPath() {
        if (this.dfsReferral == null) {
            return null;
        }
        return "smb://" + this.dfsReferral.getServer() + "/" + this.dfsReferral.getShare() + this.getUNCPath().replace('\\', '/');
    }

    @Override
    public int getPort() {
        return this.url.getPort();
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean shouldForceSigning() {
        return this.ctx.getConfig().isIpcSigningEnforced() && !this.ctx.getCredentials().isAnonymous() && this.isIPC();
    }

    @Override
    public boolean isIPC() {
        String shr = this.getShare();
        if (shr == null || "IPC$".equals(this.getShare())) {
            if (log.isDebugEnabled()) {
                log.debug("Share is IPC " + this.share);
            }
            return true;
        }
        return false;
    }

    void updateType(int t) {
        this.type = t;
    }

    @Override
    public int getType() throws CIFSException {
        if (this.type == 0) {
            if (this.getUNCPath().length() > 1) {
                this.type = 1;
            } else if (this.getShare() != null) {
                this.type = this.getShare().equals("IPC$") ? 16 : 8;
            } else if (this.url.getAuthority() == null || this.url.getAuthority().isEmpty()) {
                this.type = 2;
            } else {
                try {
                    int code;
                    NetbiosAddress nbaddr = this.getAddress().unwrap(NetbiosAddress.class);
                    if (nbaddr != null && ((code = nbaddr.getNameType()) == 29 || code == 27)) {
                        this.type = 2;
                        return this.type;
                    }
                }
                catch (CIFSException e) {
                    if (!(e.getCause() instanceof UnknownHostException)) {
                        throw e;
                    }
                    log.debug("Unknown host", (Throwable)e);
                }
                this.type = 4;
            }
        }
        return this.type;
    }

    @Override
    public boolean isWorkgroup() throws CIFSException {
        if (this.type == 2 || this.url.getHost().length() == 0) {
            this.type = 2;
            return true;
        }
        if (this.getShare() == null) {
            int code;
            NetbiosAddress addr = this.getAddress().unwrap(NetbiosAddress.class);
            if (addr != null && ((code = addr.getNameType()) == 29 || code == 27)) {
                this.type = 2;
                return true;
            }
            this.type = 4;
        }
        return false;
    }

    @Override
    public Address getAddress() throws CIFSException {
        if (this.addressIndex == 0) {
            return this.getFirstAddress();
        }
        return this.addresses[this.addressIndex - 1];
    }

    static String queryLookup(String query, String param) {
        String p;
        char[] in = query.toCharArray();
        int eq = 0;
        int st = 0;
        for (int i = 0; i < in.length; ++i) {
            char ch = in[i];
            if (ch == '&') {
                if (eq > st && (p = new String(in, st, eq - st)).equalsIgnoreCase(param)) {
                    return new String(in, ++eq, i - eq);
                }
                st = i + 1;
                continue;
            }
            if (ch != '=') continue;
            eq = i;
        }
        if (eq > st && (p = new String(in, st, eq - st)).equalsIgnoreCase(param)) {
            return new String(in, ++eq, in.length - eq);
        }
        return null;
    }

    Address getFirstAddress() throws CIFSException {
        this.addressIndex = 0;
        if (this.addresses == null) {
            String host = this.url.getHost();
            String path = this.url.getPath();
            String query = this.url.getQuery();
            try {
                if (query != null) {
                    String address;
                    String server = SmbResourceLocatorImpl.queryLookup(query, "server");
                    if (server != null && server.length() > 0) {
                        this.addresses = new UniAddress[1];
                        this.addresses[0] = this.ctx.getNameServiceClient().getByName(server);
                    }
                    if ((address = SmbResourceLocatorImpl.queryLookup(query, "address")) != null && address.length() > 0) {
                        byte[] ip = InetAddress.getByName(address).getAddress();
                        this.addresses = new UniAddress[1];
                        this.addresses[0] = new UniAddress(InetAddress.getByAddress(host, ip));
                    }
                } else if (host.length() == 0) {
                    try {
                        NetbiosAddress addr = this.ctx.getNameServiceClient().getNbtByName("\u0001\u0002__MSBROWSE__\u0002", 1, null);
                        this.addresses = new UniAddress[1];
                        this.addresses[0] = this.ctx.getNameServiceClient().getByName(addr.getHostAddress());
                    }
                    catch (UnknownHostException uhe) {
                        log.debug("Unknown host", (Throwable)uhe);
                        if (this.ctx.getConfig().getDefaultDomain() == null) {
                            throw uhe;
                        }
                        this.addresses = this.ctx.getNameServiceClient().getAllByName(this.ctx.getConfig().getDefaultDomain(), true);
                    }
                } else {
                    this.addresses = path.length() == 0 || path.equals("/") ? this.ctx.getNameServiceClient().getAllByName(host, true) : this.ctx.getNameServiceClient().getAllByName(host, false);
                }
            }
            catch (UnknownHostException e) {
                throw new CIFSException("Failed to lookup address for name " + host, e);
            }
        }
        return this.getNextAddress();
    }

    Address getNextAddress() {
        Address addr = null;
        if (this.addressIndex < this.addresses.length) {
            addr = this.addresses[this.addressIndex++];
        }
        return addr;
    }

    boolean hasNextAddress() {
        return this.addressIndex < this.addresses.length;
    }

    @Override
    public boolean isRoot() {
        return this.getShare() == null && this.getUNCPath().length() <= 1;
    }

    boolean isRootOrShare() {
        return this.getUNCPath().length() <= 1;
    }

    private synchronized void canonicalizePath() {
        char[] in = this.url.getPath().toCharArray();
        char[] out = new char[in.length];
        int length = in.length;
        int prefixLen = 0;
        int state = 0;
        block5: for (int i = 0; i < length; ++i) {
            switch (state) {
                case 0: {
                    if (in[i] != '/') {
                        throw new RuntimeCIFSException("Invalid smb: URL: " + this.url);
                    }
                    out[prefixLen++] = in[i];
                    state = 1;
                    continue block5;
                }
                case 1: {
                    if (in[i] == '/') continue block5;
                    if (in[i] == '.' && (i + 1 >= length || in[i + 1] == '/')) {
                        ++i;
                        continue block5;
                    }
                    if (i + 1 < length && in[i] == '.' && in[i + 1] == '.' && (i + 2 >= length || in[i + 2] == '/')) {
                        i += 2;
                        if (prefixLen == 1) continue block5;
                        while (--prefixLen > 1 && out[prefixLen - 1] != '/') {
                        }
                        continue block5;
                    }
                    state = 2;
                }
                case 2: {
                    if (in[i] == '/') {
                        state = 1;
                    }
                    out[prefixLen++] = in[i];
                }
            }
        }
        this.canon = new String(out, 0, prefixLen);
        if (prefixLen > 1) {
            --prefixLen;
            int firstSep = this.canon.indexOf(47, 1);
            if (firstSep < 0) {
                this.share = this.canon.substring(1);
                this.unc = "\\";
            } else if (firstSep == prefixLen) {
                this.share = this.canon.substring(1, firstSep);
                this.unc = "\\";
            } else {
                this.share = this.canon.substring(1, firstSep);
                this.unc = this.canon.substring(firstSep, prefixLen + 1).replace('/', '\\');
            }
        } else {
            this.canon = "/";
            this.share = null;
            this.unc = "\\";
        }
    }

    public int hashCode() {
        int hash;
        try {
            hash = this.getAddress().hashCode();
        }
        catch (CIFSException uhe) {
            hash = this.getServer().toUpperCase().hashCode();
        }
        return hash + this.getURLPath().toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmbResourceLocatorImpl)) {
            return false;
        }
        SmbResourceLocatorImpl o = (SmbResourceLocatorImpl)obj;
        if (SmbResourceLocatorImpl.pathNamesPossiblyEqual(this.url.getPath(), o.url.getPath()) && this.getURLPath().equalsIgnoreCase(o.getURLPath())) {
            try {
                return this.getAddress().equals(o.getAddress());
            }
            catch (CIFSException uhe) {
                log.debug("Unknown host", (Throwable)uhe);
                return this.getServer().equalsIgnoreCase(o.getServer());
            }
        }
        return false;
    }

    private static boolean pathNamesPossiblyEqual(String path1, String path2) {
        int p1 = path1.lastIndexOf(47);
        int p2 = path2.lastIndexOf(47);
        int l1 = path1.length() - p1;
        int l2 = path2.length() - p2;
        if (l1 > 1 && path1.charAt(p1 + 1) == '.') {
            return true;
        }
        if (l2 > 1 && path2.charAt(p2 + 1) == '.') {
            return true;
        }
        return l1 == l2 && path1.regionMatches(true, p1, path2, p2, l1);
    }

    @Override
    public boolean overlaps(SmbResourceLocator other) throws CIFSException {
        String tp = this.getCanonicalURL();
        String op = other.getCanonicalURL();
        return this.getAddress().equals(other.getAddress()) && tp.regionMatches(true, 0, op, 0, Math.min(tp.length(), op.length()));
    }

    @Override
    public String handleDFSReferral(DfsReferralData dr, String reqPath) {
        if (Objects.equals(this.dfsReferral, dr)) {
            return this.unc;
        }
        this.dfsReferral = dr;
        String oldUncPath = this.getUNCPath();
        int pathConsumed = dr.getPathConsumed();
        if (pathConsumed < 0) {
            log.warn("Path consumed out of range " + pathConsumed);
            pathConsumed = 0;
        } else if (pathConsumed > this.unc.length()) {
            log.warn("Path consumed out of range " + pathConsumed);
            pathConsumed = oldUncPath.length();
        }
        if (log.isDebugEnabled()) {
            log.debug("UNC is '" + oldUncPath + "'");
            log.debug("Consumed '" + oldUncPath.substring(0, pathConsumed) + "'");
        }
        String dunc = oldUncPath.substring(pathConsumed);
        if (log.isDebugEnabled()) {
            log.debug("Remaining '" + dunc + "'");
        }
        if (dunc.equals("") || dunc.equals("\\")) {
            dunc = "\\";
            this.type = 8;
        }
        if (!dr.getPath().isEmpty()) {
            dunc = "\\" + dr.getPath() + dunc;
        }
        if (dunc.charAt(0) != '\\') {
            log.warn("No slash at start of remaining DFS path " + dunc);
        }
        this.unc = dunc;
        if (dr.getShare() != null && !dr.getShare().isEmpty()) {
            this.share = dr.getShare();
        }
        if (reqPath != null && reqPath.endsWith("\\") && !dunc.endsWith("\\")) {
            dunc = dunc + "\\";
        }
        return dunc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.url.toString());
        sb.append('[');
        if (this.unc != null) {
            sb.append("unc=");
            sb.append(this.unc);
        }
        if (this.canon != null) {
            sb.append("canon=");
            sb.append(this.canon);
        }
        if (this.dfsReferral != null) {
            sb.append("dfsReferral=");
            sb.append(this.dfsReferral);
        }
        sb.append(']');
        return sb.toString();
    }
}

