/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.net.protocol.storage;

import io.minio.GetObjectArgs;
import io.minio.MinioClient;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.codelibs.core.lang.StringUtil;

public class Handler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new StorageURLConnection(u);
    }

    public class StorageURLConnection
    extends URLConnection {
        private MinioClient minioClient;
        private String bucketName;
        private String objectName;
        private StatObjectResponse statObject;

        protected StorageURLConnection(URL url) {
            super(url);
            String[] values = url.toExternalForm().split("/", 2);
            if (values.length == 2) {
                this.bucketName = values[0];
                this.objectName = values[1];
            } else {
                this.bucketName = values.length == 1 ? values[0] : "";
                this.objectName = "";
            }
        }

        @Override
        public void connect() throws IOException {
            String endpoint = System.getenv().get("STORAGE_ENDPOINT");
            String accessKey = System.getenv().get("STORAGE_ACCESS_KEY");
            String secretKey = System.getenv().get("STORAGE_SECRET_KEY");
            String region = System.getenv().get("STORAGE_SECRET_KEY");
            try {
                if (StringUtil.isBlank((String)endpoint)) {
                    throw new IOException("endpoint is blank.");
                }
                MinioClient.Builder builder = MinioClient.builder().endpoint(endpoint);
                if (StringUtil.isNotBlank((String)accessKey) && StringUtil.isNotBlank((String)secretKey)) {
                    builder.credentials(accessKey, secretKey);
                }
                if (StringUtil.isNotBlank((String)region)) {
                    builder.region(region);
                }
                this.minioClient = builder.build();
            }
            catch (Exception e) {
                throw new IOException("Failed to create MinioClient.", e);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.minioClient == null) {
                throw new IOException("Access is not ready.");
            }
            try {
                GetObjectArgs args = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.bucketName)).object(this.objectName)).build();
                return this.minioClient.getObject(args);
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException("Failed to access " + this.url, e);
            }
        }

        private StatObjectResponse getStatObject() throws InvalidKeyException, ErrorResponseException, IllegalArgumentException, InsufficientDataException, InternalException, InvalidResponseException, NoSuchAlgorithmException, XmlParserException, IOException, ServerException {
            if (this.statObject == null) {
                StatObjectArgs args = (StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(this.bucketName)).object(this.objectName)).build();
                this.statObject = this.minioClient.statObject(args);
            }
            return this.statObject;
        }

        @Override
        public long getContentLengthLong() {
            if (this.minioClient == null) {
                return -1L;
            }
            try {
                return this.getStatObject().size();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                return -1L;
            }
        }

        @Override
        public String getContentType() {
            if (this.minioClient == null) {
                return null;
            }
            try {
                return this.getStatObject().contentType();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                return null;
            }
        }

        @Override
        public long getDate() {
            return this.getLastModified();
        }

        @Override
        public long getLastModified() {
            if (this.minioClient == null) {
                return 0L;
            }
            try {
                return this.getStatObject().lastModified().toEpochSecond();
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidResponseException | ServerException | XmlParserException | IOException | IllegalArgumentException | InvalidKeyException | NoSuchAlgorithmException e) {
                return 0L;
            }
        }
    }
}

