/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.util;

import java.util.function.Consumer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathEvaluationResult;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathNodes;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.w3c.dom.Node;

public class XPathAPI {
    private final XPath xPath = this.createXPath(f -> {});

    public XPath createXPath(Consumer<XPathFactory> builder) {
        try {
            XPathFactory factory = XPathFactory.newInstance();
            builder.accept(factory);
            return factory.newXPath();
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Failed to create XPath instance.", e);
        }
    }

    public XPathNodes selectNodeList(Node contextNode, String expression) throws XPathExpressionException {
        return this.xPath.evaluateExpression(expression, contextNode, XPathNodes.class);
    }

    public XPathEvaluationResult<?> eval(Node contextNode, String expression) throws XPathExpressionException {
        return this.xPath.evaluateExpression(expression, contextNode);
    }

    public Node selectSingleNode(Node contextNode, String expression) throws XPathExpressionException {
        return this.xPath.evaluateExpression(expression, contextNode, Node.class);
    }
}

