/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;

public final class ResponseDataUtil {
    private ResponseDataUtil() {
    }

    public static File createResponseBodyFile(ResponseData responseData) {
        File tempFile = null;
        FileOutputStream fos = null;
        try (InputStream is = responseData.getResponseBody();){
            tempFile = File.createTempFile("crawler-", ".tmp");
            fos = new FileOutputStream(tempFile);
            CopyUtil.copy((InputStream)is, (OutputStream)fos);
        }
        catch (Exception e) {
            try {
                CloseableUtil.closeQuietly(fos);
                FileUtil.deleteInBackground(tempFile);
                throw new CrawlingAccessException("Could not read a response body: " + responseData.getUrl(), e);
            }
            catch (Throwable throwable) {
                CloseableUtil.closeQuietly(fos);
                throw throwable;
            }
        }
        CloseableUtil.closeQuietly((Closeable)fos);
        return tempFile;
    }
}

