/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.transformer.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathNodes;
import org.codelibs.core.beans.util.BeanUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.Constants;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.transformer.impl.AbstractTransformer;
import org.codelibs.fess.crawler.util.XPathAPI;
import org.codelibs.fess.crawler.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlTransformer
extends AbstractTransformer {
    private static final Logger logger = LoggerFactory.getLogger(XmlTransformer.class);
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+", 8);
    protected boolean namespaceAware;
    protected boolean coalescing;
    protected boolean expandEntityRef = false;
    protected boolean ignoringComments;
    protected boolean ignoringElementContentWhitespace;
    protected boolean validating;
    protected boolean includeAware;
    protected final Map<String, Object> attributeMap = new HashMap<String, Object>();
    protected final Map<String, String> featureMap = new HashMap<String, String>();
    protected Map<String, String> fieldRuleMap = new LinkedHashMap<String, String>();
    protected boolean trimSpaceEnabled = true;
    protected String charsetName = "UTF-8";
    protected Class<?> dataClass = null;
    protected LoadingCache<String, XPathAPI> xpathAPICache;
    protected long cacheDuration = 10L;

    @Resource
    public void init() {
        this.xpathAPICache = CacheBuilder.newBuilder().expireAfterAccess(this.cacheDuration, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, XPathAPI>(){

            public XPathAPI load(String key) {
                if (logger.isDebugEnabled()) {
                    logger.debug("created XPathAPI by {}", (Object)key);
                }
                return new XPathAPI();
            }
        });
    }

    @Override
    public Object getData(AccessResultData<?> accessResultData) {
        if (this.dataClass == null) {
            if (!this.getName().equals(accessResultData.getTransformerName())) {
                throw new CrawlerSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
            }
            byte[] data = accessResultData.getData();
            if (data == null) {
                return null;
            }
            String encoding = accessResultData.getEncoding();
            try {
                return new String(data, encoding == null ? "UTF-8" : encoding);
            }
            catch (UnsupportedEncodingException e) {
                if (logger.isInfoEnabled()) {
                    logger.info("Invalid charsetName: " + encoding + ". Changed to UTF-8", (Throwable)e);
                }
                return new String(data, Constants.UTF_8_CHARSET);
            }
        }
        Map<String, Object> dataMap = XmlUtil.getDataMap(accessResultData);
        if (Map.class.equals(this.dataClass)) {
            return dataMap;
        }
        try {
            Object obj = this.dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            BeanUtil.copyMapToBean(dataMap, obj);
            return obj;
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Could not create/copy a data map to " + this.dataClass, e);
        }
    }

    @Override
    public ResultData transform(ResponseData responseData) {
        ResultData resultData;
        block20: {
            if (responseData == null || !responseData.hasResponseBody()) {
                throw new CrawlingAccessException("No response body.");
            }
            InputStream is = responseData.getResponseBody();
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                for (Map.Entry<String, Object> entry : this.attributeMap.entrySet()) {
                    factory.setAttribute(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : this.featureMap.entrySet()) {
                    factory.setFeature(entry.getKey(), "true".equalsIgnoreCase((String)entry.getValue()));
                }
                factory.setCoalescing(this.coalescing);
                factory.setExpandEntityReferences(this.expandEntityRef);
                factory.setIgnoringComments(this.ignoringComments);
                factory.setIgnoringElementContentWhitespace(this.ignoringElementContentWhitespace);
                factory.setNamespaceAware(this.namespaceAware);
                factory.setValidating(this.validating);
                factory.setXIncludeAware(this.includeAware);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(is);
                StringBuilder buf = new StringBuilder(1000);
                buf.append(this.getResultDataHeader());
                for (Map.Entry<String, String> entry : this.fieldRuleMap.entrySet()) {
                    ArrayList<String> nodeStrList = new ArrayList<String>();
                    try {
                        XPathNodes nodeList = this.getNodeList(document, entry.getValue());
                        for (int i = 0; i < nodeList.size(); ++i) {
                            Node node = nodeList.get(i);
                            nodeStrList.add(node.getTextContent());
                        }
                    }
                    catch (XPathExpressionException e) {
                        logger.warn("Could not parse a value of " + entry.getKey() + ":" + entry.getValue(), (Throwable)e);
                    }
                    if (nodeStrList.size() == 1) {
                        buf.append(this.getResultDataBody(entry.getKey(), (String)nodeStrList.get(0)));
                        continue;
                    }
                    if (nodeStrList.size() <= 1) continue;
                    buf.append(this.getResultDataBody(entry.getKey(), nodeStrList));
                }
                buf.append(this.getAdditionalData(responseData, document));
                buf.append(this.getResultDataFooter());
                ResultData resultData2 = new ResultData();
                resultData2.setTransformerName(this.getName());
                String data = buf.toString().trim();
                try {
                    resultData2.setData(data.getBytes(this.charsetName));
                }
                catch (UnsupportedEncodingException e) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Invalid charsetName: " + this.charsetName + ". Changed to UTF-8", (Throwable)e);
                    }
                    this.charsetName = Constants.UTF_8_CHARSET.name();
                    resultData2.setData(data.getBytes(Constants.UTF_8_CHARSET));
                }
                resultData2.setEncoding(this.charsetName);
                resultData = resultData2;
                if (is == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CrawlerSystemException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CrawlerSystemException("Could not store data.", e);
                }
            }
            is.close();
        }
        return resultData;
    }

    protected XPathNodes getNodeList(Document doc, String xpath) throws XPathExpressionException {
        XPath xPathApi = this.getXPathAPI().createXPath(f -> {});
        xPathApi.setNamespaceContext(new DefaultNamespaceContext(doc.getNodeType() == 9 ? doc.getDocumentElement() : doc));
        return xPathApi.evaluateExpression(xpath, doc, XPathNodes.class);
    }

    protected XPathAPI getXPathAPI() {
        try {
            return (XPathAPI)this.xpathAPICache.get((Object)Thread.currentThread().getName());
        }
        catch (ExecutionException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to retrieval a cache.", (Throwable)e);
            }
            return new XPathAPI();
        }
    }

    protected String getResultDataHeader() {
        return "<?xml version=\"1.0\"?>\n<doc>\n";
    }

    protected String getResultDataBody(String name, String value) {
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + this.trimSpace(XmlUtil.escapeXml(value != null ? value : "")) + "</field>\n";
    }

    protected String getResultDataBody(String name, List<String> values) {
        StringBuilder buf = new StringBuilder();
        buf.append("<list>");
        if (values != null && !values.isEmpty()) {
            for (String value : values) {
                buf.append("<item>");
                buf.append(this.trimSpace(XmlUtil.escapeXml(value)));
                buf.append("</item>");
            }
        }
        buf.append("</list>");
        return "<field name=\"" + XmlUtil.escapeXml(name) + "\">" + buf.toString().trim() + "</field>\n";
    }

    protected String getAdditionalData(ResponseData responseData, Document document) {
        return "";
    }

    protected String getResultDataFooter() {
        return "</doc>";
    }

    protected String trimSpace(String value) {
        if (this.trimSpaceEnabled) {
            Matcher matcher = SPACE_PATTERN.matcher(value);
            return matcher.replaceAll(" ").trim();
        }
        return value;
    }

    public void addAttribute(String name, Object value) {
        this.attributeMap.put(name, value);
    }

    public void addFeature(String key, String value) {
        this.featureMap.put(key, value);
    }

    public void addFieldRule(String name, String xpath) {
        this.fieldRuleMap.put(name, xpath);
    }

    public Map<String, String> getFieldRuleMap() {
        return this.fieldRuleMap;
    }

    public void setFieldRuleMap(Map<String, String> fieldRuleMap) {
        this.fieldRuleMap = fieldRuleMap;
    }

    public boolean isTrimSpace() {
        return this.trimSpaceEnabled;
    }

    public void setTrimSpace(boolean trimSpace) {
        this.trimSpaceEnabled = trimSpace;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public Class<?> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<?> dataClass) {
        this.dataClass = dataClass;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isExpandEntityRef() {
        return this.expandEntityRef;
    }

    public void setExpandEntityRef(boolean expandEntityRef) {
        this.expandEntityRef = expandEntityRef;
    }

    public boolean isIgnoringComments() {
        return this.ignoringComments;
    }

    public void setIgnoringComments(boolean ignoringComments) {
        this.ignoringComments = ignoringComments;
    }

    public boolean isIgnoringElementContentWhitespace() {
        return this.ignoringElementContentWhitespace;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringElementContentWhitespace) {
        this.ignoringElementContentWhitespace = ignoringElementContentWhitespace;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isIncludeAware() {
        return this.includeAware;
    }

    public void setIncludeAware(boolean includeAware) {
        this.includeAware = includeAware;
    }

    public void setCacheDuration(long cacheDuration) {
        this.cacheDuration = cacheDuration;
    }

    private static final class DefaultNamespaceContext
    implements NamespaceContext {
        private final Node doc;

        public DefaultNamespaceContext(Node doc) {
            this.doc = doc;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.getNamespaceForPrefix(prefix, this.doc);
        }

        private String getNamespaceForPrefix(String prefix, Node namespaceContext) {
            String namespace = null;
            if ("xml".equals(prefix)) {
                namespace = "http://www.w3.org/XML/1998/namespace";
            } else {
                short type;
                block0: for (Node parent = namespaceContext; null != parent && null == namespace && ((type = parent.getNodeType()) == 1 || type == 5); parent = parent.getParentNode()) {
                    if (type != 1) continue;
                    if (parent.getNodeName().indexOf(prefix + ":") == 0) {
                        return parent.getNamespaceURI();
                    }
                    NamedNodeMap nnm = parent.getAttributes();
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        String p;
                        Node attr = nnm.item(i);
                        String aname = attr.getNodeName();
                        boolean isPrefix = aname.startsWith("xmlns:");
                        if (!isPrefix && !"xmlns".equals(aname)) continue;
                        int index = aname.indexOf(58);
                        String string = p = isPrefix ? aname.substring(index + 1) : "";
                        if (!p.equals(prefix)) continue;
                        namespace = attr.getNodeValue();
                        continue block0;
                    }
                }
            }
            if (StringUtil.isNotBlank((String)namespace)) {
                return namespace;
            }
            return "http://crawler.codelibs.org/namespace/" + prefix;
        }

        @Override
        public Iterator<String> getPrefixes(String val) {
            return null;
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }
    }
}

