/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.transformer.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.fess.crawler.Constants;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.transformer.impl.HtmlTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTransformer
extends HtmlTransformer {
    private static final Logger logger = LoggerFactory.getLogger(FileTransformer.class);
    protected String path;
    protected String questionStr = "_QUEST_";
    protected String colonStr = "_CLN_";
    protected String semicolonStr = "_SCLN_";
    protected String ampersandStr = "_AMP_";
    protected int maxDuplicatedPath = 100;
    protected String charsetName = "UTF-8";
    protected File baseDir;

    protected File createFile(String path) {
        String[] paths = path.split("/");
        File targetFile = this.baseDir;
        for (int i = 0; i < paths.length - 1; ++i) {
            File file = new File(targetFile, paths[i]);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    for (int j = 0; j < this.maxDuplicatedPath; ++j) {
                        file = new File(targetFile, paths[i] + "_" + j);
                        if (!file.exists()) {
                            if (!file.mkdirs()) {
                                throw new CrawlerSystemException("Could not create " + file.getAbsolutePath());
                            }
                        } else if (!file.isDirectory()) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (!file.mkdirs()) {
                throw new CrawlerSystemException("Could not create " + file.getAbsolutePath());
            }
            targetFile = file;
        }
        File file = new File(targetFile, paths[paths.length - 1]);
        if (file.exists()) {
            for (int i = 0; i < this.maxDuplicatedPath; ++i) {
                file = new File(targetFile, paths[paths.length - 1] + "_" + i);
                if (file.exists()) continue;
                targetFile = file;
                break;
            }
        } else {
            targetFile = file;
        }
        return targetFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeData(ResponseData responseData, ResultData resultData) {
        resultData.setTransformerName(this.getName());
        this.initBaseDir();
        String url = responseData.getUrl();
        String path = this.getFilePath(url);
        FileTransformer fileTransformer = this;
        synchronized (fileTransformer) {
            File file = this.createFile(path);
            try (InputStream is = responseData.getResponseBody();
                 FileOutputStream os = new FileOutputStream(file);){
                CopyUtil.copy((InputStream)is, (OutputStream)os);
            }
            catch (IOException e) {
                throw new CrawlerSystemException("Could not store " + file.getAbsolutePath(), e);
            }
        }
        try {
            resultData.setData(path.getBytes(this.charsetName));
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isInfoEnabled()) {
                logger.info("Invalid charsetName: " + this.charsetName + ". Changed to UTF-8", (Throwable)e);
            }
            this.charsetName = Constants.UTF_8_CHARSET.name();
            resultData.setData(path.getBytes(Constants.UTF_8_CHARSET));
        }
        resultData.setEncoding(this.charsetName);
    }

    private void initBaseDir() {
        if (this.baseDir == null) {
            if (this.path == null) {
                this.baseDir = new File(".");
            } else {
                this.baseDir = new File(this.path);
                if (!this.baseDir.isDirectory() && !this.baseDir.mkdirs()) {
                    throw new CrawlerSystemException("Could not create " + this.baseDir.getAbsolutePath());
                }
            }
        }
    }

    protected String getFilePath(String url) {
        return url.replaceAll("/+", "/").replace("./", "").replace("../", "").replaceAll("/$", "/index.html").replaceAll("\\?", this.questionStr).replaceAll(":", this.colonStr).replaceAll(";", this.semicolonStr).replaceAll("&", this.ampersandStr);
    }

    @Override
    public Object getData(AccessResultData<?> accessResultData) {
        String filePath;
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new CrawlerSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        String encoding = accessResultData.getEncoding();
        try {
            filePath = new String(data, encoding == null ? "UTF-8" : encoding);
        }
        catch (UnsupportedEncodingException e) {
            filePath = new String(data, Constants.UTF_8_CHARSET);
        }
        return new File(this.baseDir, filePath);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getQuestionStr() {
        return this.questionStr;
    }

    public void setQuestionStr(String questionStr) {
        this.questionStr = questionStr;
    }

    public String getColonStr() {
        return this.colonStr;
    }

    public void setColonStr(String colonStr) {
        this.colonStr = colonStr;
    }

    public String getSemicolonStr() {
        return this.semicolonStr;
    }

    public void setSemicolonStr(String semicolonStr) {
        this.semicolonStr = semicolonStr;
    }

    public String getAmpersandStr() {
        return this.ampersandStr;
    }

    public void setAmpersandStr(String ampersandStr) {
        this.ampersandStr = ampersandStr;
    }

    public int getMaxDuplicatedPath() {
        return this.maxDuplicatedPath;
    }

    public void setMaxDuplicatedPath(int maxDuplicatedPath) {
        this.maxDuplicatedPath = maxDuplicatedPath;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }
}

