/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.transformer.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.entity.ResultData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.transformer.impl.AbstractTransformer;

public class BinaryTransformer
extends AbstractTransformer {
    @Override
    public ResultData transform(ResponseData responseData) {
        ResultData resultData;
        if (responseData == null || !responseData.hasResponseBody()) {
            throw new CrawlingAccessException("No response body.");
        }
        ResultData resultData2 = new ResultData();
        resultData2.setTransformerName(this.getName());
        BufferedInputStream bis = new BufferedInputStream(responseData.getResponseBody());
        try {
            resultData2.setData(IOUtils.toByteArray((InputStream)bis));
            resultData2.setEncoding(responseData.getCharSet());
            resultData = resultData2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new CrawlerSystemException("Could not convert the input stream.", e);
            }
        }
        bis.close();
        return resultData;
    }

    @Override
    public Object getData(AccessResultData<?> accessResultData) {
        if (!this.getName().equals(accessResultData.getTransformerName())) {
            throw new CrawlerSystemException("Transformer is invalid. Use " + accessResultData.getTransformerName() + ". This transformer is " + this.getName() + ".");
        }
        byte[] data = accessResultData.getData();
        if (data == null) {
            return null;
        }
        return new ByteArrayInputStream(data);
    }
}

