/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.service.impl;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.codelibs.fess.crawler.entity.AccessResultData;
import org.codelibs.fess.crawler.entity.AccessResultDataImpl;
import org.codelibs.fess.crawler.entity.AccessResultImpl;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.helper.MemoryDataHelper;
import org.codelibs.fess.crawler.service.DataService;
import org.codelibs.fess.crawler.util.AccessResultCallback;

public class DataServiceImpl
implements DataService<AccessResultImpl<Long>> {
    protected static volatile long idCount = 0L;
    private static Object idCountLock = new Object();
    @Resource
    protected MemoryDataHelper dataHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(AccessResultImpl<Long> accessResult) {
        if (accessResult == null) {
            throw new CrawlerSystemException("AccessResult is null.");
        }
        Object object = idCountLock;
        synchronized (object) {
            accessResult.setId(++idCount);
            AccessResultData<Long> accessResultData = accessResult.getAccessResultData();
            if (accessResultData == null) {
                accessResultData = new AccessResultDataImpl<Long>();
                accessResultData.setTransformerName("NONE");
                accessResult.setAccessResultData(accessResultData);
            }
            accessResultData.setId(accessResult.getId());
            Map<String, AccessResultImpl<Long>> arMap = this.dataHelper.getAccessResultMap(accessResult.getSessionId());
            if (arMap.containsKey(accessResult.getUrl())) {
                throw new CrawlerSystemException(accessResult.getUrl() + " already exists.");
            }
            arMap.put(accessResult.getUrl(), accessResult);
        }
    }

    @Override
    public int getCount(String sessionId) {
        return this.dataHelper.getAccessResultMap(sessionId).size();
    }

    @Override
    public void delete(String sessionId) {
        this.dataHelper.deleteAccessResultMap(sessionId);
    }

    @Override
    public void deleteAll() {
        this.dataHelper.clearUrlQueueList();
    }

    @Override
    public AccessResultImpl<Long> getAccessResult(String sessionId, String url) {
        return this.dataHelper.getAccessResultMap(sessionId).get(url);
    }

    @Override
    public List<AccessResultImpl<Long>> getAccessResultList(String url, boolean hasData) {
        return this.dataHelper.getAccessResultList(url);
    }

    @Override
    public void iterate(String sessionId, AccessResultCallback<AccessResultImpl<Long>> accessResultCallback) {
        Map<String, AccessResultImpl<Long>> arMap = this.dataHelper.getAccessResultMap(sessionId);
        for (Map.Entry<String, AccessResultImpl<Long>> entry : arMap.entrySet()) {
            accessResultCallback.iterate(entry.getValue());
        }
    }

    @Override
    public void update(AccessResultImpl<Long> accessResult) {
        Map<String, AccessResultImpl<Long>> arMap = this.dataHelper.getAccessResultMap(accessResult.getSessionId());
        if (!arMap.containsKey(accessResult.getUrl())) {
            throw new CrawlerSystemException(accessResult.getUrl() + " is not found.");
        }
        arMap.put(accessResult.getUrl(), accessResult);
    }

    @Override
    public void update(List<AccessResultImpl<Long>> accessResultList) {
        for (AccessResultImpl<Long> accessResult : accessResultList) {
            this.update(accessResult);
        }
    }
}

