/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.helper.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.MimeTypeException;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;

public class MimeTypeHelperImpl
implements MimeTypeHelper {
    protected static final String MIME_TYPES_RESOURCE_NAME = "/org/codelibs/fess/crawler/mime/tika-mimetypes.xml";
    protected MimeTypes mimeTypes;
    protected boolean useFilename = false;
    protected boolean useFilenameOnOctetStream = true;

    public MimeTypeHelperImpl() {
        try {
            this.mimeTypes = MimeTypesFactory.create((String)MIME_TYPES_RESOURCE_NAME);
        }
        catch (Exception e) {
            throw new CrawlerSystemException("Could not initialize MimeTypeHelper.", e);
        }
    }

    @Override
    public String getContentType(InputStream is, String filename) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resourceName", filename);
        return this.getContentType(is, params);
    }

    @Override
    public String getContentType(InputStream is, Map<String, String> params) {
        String filename = params.get("resourceName");
        if (StringUtil.isEmpty((String)filename) && is == null) {
            throw new MimeTypeException("The filename or input stream is empty.");
        }
        Metadata metadata = new Metadata();
        metadata.add("resourceName", this.normalizeFilename(filename));
        try {
            MediaType mediaType;
            if (this.useFilename && !MediaType.OCTET_STREAM.equals((Object)(mediaType = this.mimeTypes.detect(null, metadata)))) {
                return mediaType.getType() + "/" + mediaType.getSubtype();
            }
            mediaType = this.mimeTypes.detect(is == null || is.markSupported() ? is : new BufferedInputStream(is), metadata);
            if (this.useFilenameOnOctetStream && MediaType.OCTET_STREAM.equals((Object)mediaType)) {
                MediaType mediaTypeFromFilename = this.mimeTypes.detect(null, metadata);
                return mediaTypeFromFilename.getType() + "/" + mediaTypeFromFilename.getSubtype();
            }
            return mediaType.getType() + "/" + mediaType.getSubtype();
        }
        catch (IOException e) {
            throw new MimeTypeException("Could not detect a content type.", e);
        }
    }

    protected String normalizeFilename(String filename) {
        if (StringUtil.isBlank((String)filename)) {
            return filename;
        }
        StringBuilder buf = new StringBuilder(filename.length() + 10);
        block7: for (int i = 0; i < filename.length(); ++i) {
            char c = filename.charAt(i);
            switch (c) {
                case '?': {
                    buf.append("%3f");
                    continue block7;
                }
                case '#': {
                    buf.append("%23");
                    continue block7;
                }
                case '@': {
                    buf.append("%40");
                    continue block7;
                }
                case ':': {
                    buf.append("%3a");
                    continue block7;
                }
                case '/': {
                    buf.append("%2f");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public void setUseFilename(boolean useFilename) {
        this.useFilename = useFilename;
    }

    public void setUseFilenameOnOctetStream(boolean useFilenameOnOctetStream) {
        this.useFilenameOnOctetStream = useFilenameOnOctetStream;
    }
}

