/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Pattern;
import org.codelibs.fess.crawler.entity.AccessResultImpl;
import org.codelibs.fess.crawler.entity.UrlQueueImpl;

public class MemoryDataHelper {
    protected volatile Map<String, Queue<UrlQueueImpl<Long>>> urlQueueMap = new HashMap<String, Queue<UrlQueueImpl<Long>>>();
    protected volatile Map<String, Map<String, AccessResultImpl<Long>>> sessionMap = new HashMap<String, Map<String, AccessResultImpl<Long>>>();
    protected volatile Map<String, List<Pattern>> includeUrlPatternMap = new HashMap<String, List<Pattern>>();
    protected volatile Map<String, List<Pattern>> excludeUrlPatternMap = new HashMap<String, List<Pattern>>();

    public void clear() {
        this.urlQueueMap.clear();
        this.sessionMap.clear();
    }

    public synchronized Queue<UrlQueueImpl<Long>> getUrlQueueList(String sessionId) {
        Queue<UrlQueueImpl<Long>> urlQueueList = this.urlQueueMap.get(sessionId);
        if (urlQueueList == null) {
            urlQueueList = new LinkedList<UrlQueueImpl<Long>>();
            this.urlQueueMap.put(sessionId, urlQueueList);
        }
        return urlQueueList;
    }

    public synchronized void addUrlQueueList(String sessionId, Queue<UrlQueueImpl<Long>> urlQueueList) {
        Queue<UrlQueueImpl<Long>> uqList = this.getUrlQueueList(sessionId);
        uqList.addAll(urlQueueList);
        this.urlQueueMap.put(sessionId, uqList);
    }

    public synchronized void removeUrlQueueList(String sessionId) {
        this.urlQueueMap.remove(sessionId);
    }

    public synchronized void clearUrlQueueList() {
        this.urlQueueMap.clear();
    }

    public synchronized Map<String, AccessResultImpl<Long>> getAccessResultMap(String sessionId) {
        Map<String, AccessResultImpl<Long>> arMap = this.sessionMap.get(sessionId);
        if (arMap == null) {
            arMap = new HashMap<String, AccessResultImpl<Long>>();
            this.sessionMap.put(sessionId, arMap);
        }
        return arMap;
    }

    public synchronized void deleteAccessResultMap(String sessionId) {
        this.sessionMap.remove(sessionId);
    }

    public synchronized void deleteAllAccessResultMap() {
        this.sessionMap.clear();
    }

    public synchronized List<AccessResultImpl<Long>> getAccessResultList(String url) {
        ArrayList<AccessResultImpl<Long>> acList = new ArrayList<AccessResultImpl<Long>>();
        for (Map.Entry<String, Map<String, AccessResultImpl<Long>>> entry : this.sessionMap.entrySet()) {
            AccessResultImpl<Long> ar;
            if (entry.getValue() == null || (ar = entry.getValue().get(url)) == null) continue;
            acList.add(ar);
        }
        return acList;
    }

    public synchronized void addIncludeUrlPattern(String sessionId, String url) {
        List<Pattern> patternList = this.getIncludeUrlPatternList(sessionId);
        patternList.add(Pattern.compile(url));
    }

    public List<Pattern> getIncludeUrlPatternList(String sessionId) {
        List<Pattern> patternList = this.includeUrlPatternMap.get(sessionId);
        if (patternList == null) {
            patternList = new ArrayList<Pattern>();
            this.includeUrlPatternMap.put(sessionId, patternList);
        }
        return patternList;
    }

    public synchronized void addExcludeUrlPattern(String sessionId, String url) {
        List<Pattern> patternList = this.getExcludeUrlPatternList(sessionId);
        patternList.add(Pattern.compile(url));
    }

    public List<Pattern> getExcludeUrlPatternList(String sessionId) {
        List<Pattern> patternList = this.excludeUrlPatternMap.get(sessionId);
        if (patternList == null) {
            patternList = new ArrayList<Pattern>();
            this.excludeUrlPatternMap.put(sessionId, patternList);
        }
        return patternList;
    }

    public synchronized void clearUrlPattern(String sessionId) {
        this.includeUrlPatternMap.remove(sessionId);
        this.excludeUrlPatternMap.remove(sessionId);
    }

    public synchronized void clearUrlPattern() {
        this.includeUrlPatternMap.clear();
        this.excludeUrlPatternMap.clear();
    }
}

