/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.codelibs.fess.crawler.extractor.ExtractorFactory;
import org.codelibs.fess.crawler.extractor.impl.AbstractExtractor;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.codelibs.fess.crawler.util.IgnoreCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipExtractor
extends AbstractExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ZipExtractor.class);
    @Resource
    protected ArchiveStreamFactory archiveStreamFactory;
    protected long maxContentSize = -1L;

    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        StringBuilder buf;
        block14: {
            if (in == null) {
                throw new CrawlerSystemException("The inputstream is null.");
            }
            MimeTypeHelper mimeTypeHelper = this.getMimeTypeHelper();
            ExtractorFactory extractorFactory = this.getExtractorFactory();
            buf = new StringBuilder(1000);
            try (ArchiveInputStream ais = this.archiveStreamFactory.createArchiveInputStream(in.markSupported() ? in : new BufferedInputStream(in));){
                ZipArchiveEntry entry = null;
                long contentSize = 0L;
                while ((entry = (ZipArchiveEntry)ais.getNextEntry()) != null) {
                    Extractor extractor;
                    if (this.maxContentSize != -1L && (contentSize += entry.getSize()) > this.maxContentSize) {
                        throw new MaxLengthExceededException("Extracted size is " + contentSize + " > " + this.maxContentSize);
                    }
                    String filename = entry.getName();
                    String mimeType = mimeTypeHelper.getContentType(null, filename);
                    if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) continue;
                    try {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("resourceName", filename);
                        buf.append(extractor.getText(new IgnoreCloseInputStream((InputStream)ais), map).getContent());
                        buf.append('\n');
                    }
                    catch (Exception e) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Exception in an internal extractor.", (Throwable)e);
                    }
                }
            }
            catch (MaxLengthExceededException e) {
                throw e;
            }
            catch (Exception e) {
                if (buf.length() != 0) break block14;
                throw new ExtractException("Could not extract a content.", e);
            }
        }
        return new ExtractData(buf.toString().trim());
    }

    public void setMaxContentSize(long maxContentSize) {
        this.maxContentSize = maxContentSize;
    }
}

