/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.misc.Pair;
import org.codelibs.fess.crawler.extractor.impl.AbstractExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PasswordBasedExtractor
extends AbstractExtractor {
    private static final Logger logger = LoggerFactory.getLogger(PasswordBasedExtractor.class);
    protected Map<Pattern, String> passwordMap = new HashMap<Pattern, String>();
    private final Map<String, List<Pair<Pattern, String>>> configPasswordMap = new ConcurrentHashMap<String, List<Pair<Pattern, String>>>();

    public void addPassword(String regex, String password) {
        this.passwordMap.put(Pattern.compile(regex), password);
    }

    protected String getPassword(Map<String, String> params) {
        String value;
        String url;
        String string = url = params != null ? params.get("url") : null;
        if (!this.passwordMap.isEmpty()) {
            String resourceName = params != null ? params.get("resourceName") : null;
            String value2 = null;
            if (StringUtil.isNotEmpty((String)url)) {
                value2 = url;
            } else if (StringUtil.isNotEmpty((String)resourceName)) {
                value2 = resourceName;
            }
            if (value2 != null) {
                for (Map.Entry<Pattern, String> entry : this.passwordMap.entrySet()) {
                    if (!entry.getKey().matcher(value2).matches()) continue;
                    return entry.getValue();
                }
            }
        }
        if (params != null && url != null && StringUtil.isNotBlank((String)(value = params.get("file.passwords")))) {
            List<Object> list = this.configPasswordMap.get(value);
            if (list == null) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    Map map = (Map)mapper.readValue(value, (TypeReference)new TypeReference<Map<String, String>>(){});
                    list = map.entrySet().stream().map(e -> new Pair((Object)Pattern.compile((String)e.getKey()), (Object)((String)e.getValue()))).collect(Collectors.toList());
                }
                catch (Exception e2) {
                    logger.warn("Failed to parse passwords for " + url, (Throwable)e2);
                    list = Collections.emptyList();
                }
                this.configPasswordMap.put(value, list);
            }
            for (Pair pair : list) {
                if (!((Pattern)pair.getFirst()).matcher(url).matches()) continue;
                return (String)pair.getSecond();
            }
        }
        return params != null ? params.get("org.apache.tika.parser.pdf.password") : null;
    }
}

