/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import jp.gr.java_conf.dangan.util.lha.LhaFile;
import jp.gr.java_conf.dangan.util.lha.LhaHeader;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.ExtractException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.extractor.Extractor;
import org.codelibs.fess.crawler.extractor.ExtractorFactory;
import org.codelibs.fess.crawler.extractor.impl.AbstractExtractor;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.codelibs.fess.crawler.util.IgnoreCloseInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LhaExtractor
extends AbstractExtractor {
    private static final Logger logger = LoggerFactory.getLogger(LhaExtractor.class);
    protected long maxContentSize = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExtractData getText(InputStream in, Map<String, String> params) {
        if (in == null) {
            throw new CrawlerSystemException("The inputstream is null.");
        }
        MimeTypeHelper mimeTypeHelper = this.getMimeTypeHelper();
        ExtractorFactory extractorFactory = this.getExtractorFactory();
        StringBuilder buf = new StringBuilder(1000);
        File tempFile = null;
        LhaFile lhaFile = null;
        try {
            tempFile = File.createTempFile("crawler-", ".lzh");
            try (FileOutputStream fos = new FileOutputStream(tempFile);){
                CopyUtil.copy((InputStream)in, (OutputStream)fos);
            }
            lhaFile = new LhaFile(tempFile);
            Enumeration entries = lhaFile.entries();
            long contentSize = 0L;
            while (entries.hasMoreElements()) {
                Extractor extractor;
                LhaHeader head = (LhaHeader)entries.nextElement();
                if (this.maxContentSize != -1L && (contentSize += head.getOriginalSize()) > this.maxContentSize) {
                    throw new MaxLengthExceededException("Extracted size is " + contentSize + " > " + this.maxContentSize);
                }
                String filename = head.getPath();
                String mimeType = mimeTypeHelper.getContentType(null, filename);
                if (mimeType == null || (extractor = extractorFactory.getExtractor(mimeType)) == null) continue;
                InputStream is = null;
                try {
                    is = lhaFile.getInputStream(head);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("resourceName", filename);
                    buf.append(extractor.getText(new IgnoreCloseInputStream(is), map).getContent());
                    buf.append('\n');
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Exception in an internal extractor.", (Throwable)e);
                }
                finally {
                    CloseableUtil.closeQuietly((Closeable)is);
                }
            }
        }
        catch (MaxLengthExceededException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExtractException("Could not extract a content.", e);
        }
        finally {
            if (lhaFile != null) {
                try {
                    lhaFile.close();
                }
                catch (IOException iOException) {}
            }
            FileUtil.deleteInBackground((File)tempFile);
        }
        return new ExtractData(buf.toString().trim());
    }

    public void setMaxContentSize(long maxContentSize) {
        this.maxContentSize = maxContentSize;
    }
}

