/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.extractor;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.codelibs.fess.crawler.entity.ExtractData;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractorBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExtractorBuilder.class);
    private final InputStream in;
    private final Map<String, String> params;
    private final CrawlerContainer crawlerContainer;
    private String mimeType;
    private String filename;
    private int cacheFileSize = 1000000;
    private String extractorName = "tikaExtractor";
    private long maxContentLength = -1L;

    protected ExtractorBuilder(CrawlerContainer crawlerContainer, InputStream in, Map<String, String> params) {
        this.crawlerContainer = crawlerContainer;
        this.in = in;
        this.params = params;
    }

    public ExtractorBuilder mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public ExtractorBuilder filename(String filename) {
        this.filename = filename;
        return this;
    }

    public ExtractorBuilder extractorName(String extractorName) {
        this.extractorName = extractorName;
        return this;
    }

    public ExtractorBuilder maxContentLength(long maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public ExtractorBuilder cacheFileSize(int cacheFileSize) {
        this.cacheFileSize = cacheFileSize;
        return this;
    }

    /*
     * Exception decompiling
     */
    public ExtractData extract() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getMimeType(DeferredFileOutputStream out) throws IOException {
        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
        try (InputStream is = this.getContentInputStream(out);){
            String string = mimeTypeHelper.getContentType(is, this.filename);
            return string;
        }
    }

    protected InputStream getContentInputStream(DeferredFileOutputStream out) throws IOException {
        if (out.isInMemory()) {
            return new ByteArrayInputStream(out.getData());
        }
        return new FileInputStream(out.getFile());
    }

    protected long getContentLength(DeferredFileOutputStream out) throws IOException {
        if (out.isInMemory()) {
            return out.getData().length;
        }
        return out.getFile().length();
    }
}

