/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Resource;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilters;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.TrustManagerUtils;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.CopyUtil;
import org.codelibs.core.io.FileUtil;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.client.ftp.FtpAuthentication;
import org.codelibs.fess.crawler.client.ftp.FtpAuthenticationHolder;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerLoginFailureException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(FtpClient.class);
    public static final String FTP_FILE_GROUP = "ftpFileGroup";
    public static final String FTP_FILE_USER = "ftpFileUser";
    public static final String FTP_AUTHENTICATIONS_PROPERTY = "ftpAuthentications";
    protected String charset = "UTF-8";
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    protected volatile FtpAuthenticationHolder ftpAuthenticationHolder;
    protected FTPClientConfig ftpClientConfig;
    protected final Queue<FTPClient> ftpClientQueue = new ConcurrentLinkedQueue<FTPClient>();
    protected String activeExternalHost;
    protected int activeMinPort;
    protected int activeMaxPort;
    protected boolean autodetectEncoding;
    protected int connectTimeout;
    protected int dataTimeout;
    protected String controlEncoding;
    protected int bufferSize;
    protected String passiveLocalHost;
    protected boolean passiveNatWorkaround;
    protected String reportActiveExternalHost;
    protected boolean useEPSVwithIPv4;
    protected Boolean isImplicit;
    protected String trustManager;

    @Override
    public synchronized void init() {
        if (this.ftpAuthenticationHolder != null) {
            return;
        }
        super.init();
        String systemKey = this.getInitParameter("ftpConfigSystemKey", "UNIX", String.class);
        this.ftpClientConfig = new FTPClientConfig(systemKey);
        String serverLanguageCode = this.getInitParameter("ftpConfigServerLanguageCode", "en", String.class);
        this.ftpClientConfig.setServerLanguageCode(serverLanguageCode);
        String serverTimeZoneId = this.getInitParameter("ftpConfigServerTimeZoneId", null, String.class);
        if (serverTimeZoneId != null) {
            this.ftpClientConfig.setServerTimeZoneId(serverTimeZoneId);
        }
        this.activeExternalHost = this.getInitParameter("activeExternalHost", null, String.class);
        this.activeMinPort = this.getInitParameter("activeMinPort", -1, Integer.class);
        this.activeMaxPort = this.getInitParameter("activeMaxPort", -1, Integer.class);
        this.autodetectEncoding = this.getInitParameter("autodetectEncoding", true, Boolean.class);
        this.connectTimeout = this.getInitParameter("connectTimeout", 0, Integer.class);
        this.dataTimeout = this.getInitParameter("dataTimeout", -1, Integer.class);
        this.controlEncoding = this.getInitParameter("controlEncoding", "UTF-8", String.class);
        this.bufferSize = this.getInitParameter("bufferSize", 0, Integer.class);
        this.passiveLocalHost = this.getInitParameter("passiveLocalHost", null, String.class);
        this.passiveNatWorkaround = this.getInitParameter("passiveNatWorkaround", true, Boolean.class);
        this.reportActiveExternalHost = this.getInitParameter("reportActiveExternalHost", null, String.class);
        this.useEPSVwithIPv4 = this.getInitParameter("useEPSVwithIPv4", false, Boolean.class);
        this.isImplicit = this.getInitParameter("isImplicit", null, Boolean.class);
        this.trustManager = this.getInitParameter("trustManager", null, String.class);
        FtpAuthenticationHolder holder = new FtpAuthenticationHolder();
        FtpAuthentication[] ftpAuthentications = this.getInitParameter(FTP_AUTHENTICATIONS_PROPERTY, new FtpAuthentication[0], FtpAuthentication[].class);
        if (ftpAuthentications != null) {
            for (FtpAuthentication ftpAuthentication : ftpAuthentications) {
                holder.add(ftpAuthentication);
            }
        }
        this.ftpAuthenticationHolder = holder;
    }

    @Override
    public void close() {
        if (this.ftpAuthenticationHolder == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Closing FtpClient...");
        }
        this.ftpAuthenticationHolder = null;
        for (FTPClient ftpClient : this.ftpClientQueue) {
            try {
                ftpClient.disconnect();
            }
            catch (IOException e) {
                logger.debug("Failed to disconnect FTPClient.", (Throwable)e);
            }
        }
    }

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (this.ftpAuthenticationHolder == null) {
            this.init();
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (accessTimeoutTarget != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData = new ResponseData();
        FTPClient client = null;
        try {
            responseData.setMethod("GET");
            FtpInfo ftpInfo = new FtpInfo(uri);
            responseData.setUrl(ftpInfo.toUrl());
            client = this.getClient(ftpInfo);
            FTPFile file = null;
            client.changeWorkingDirectory(ftpInfo.getParent());
            this.validateRequest(client);
            if (ftpInfo.getName() == null) {
                HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                if (includeContent) {
                    try {
                        FTPFile[] files = client.listFiles(ftpInfo.getParent(), FTPFileFilters.NON_NULL);
                        this.validateRequest(client);
                        for (FTPFile f : files) {
                            String chileUri = ftpInfo.toChildUrl(f.getName());
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                        }
                    }
                    catch (IOException e) {
                        this.disconnectInternalClient(client);
                        throw new CrawlingAccessException("Could not access " + uri, e);
                    }
                }
                this.ftpClientQueue.offer(client);
                throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData");
            }
            FTPFile[] files = client.listFiles(null, FTPFileFilters.NON_NULL);
            this.validateRequest(client);
            for (FTPFile f : files) {
                if (!ftpInfo.getName().equals(f.getName())) continue;
                file = f;
                break;
            }
            this.updateResponseData(uri, includeContent, responseData, client, ftpInfo, file);
        }
        catch (CrawlerSystemException e) {
            CloseableUtil.closeQuietly((Closeable)responseData);
            throw e;
        }
        catch (Exception e) {
            CloseableUtil.closeQuietly((Closeable)responseData);
            throw new CrawlingAccessException("Could not access " + uri, e);
        }
        return responseData;
    }

    protected void disconnectInternalClient(FTPClient client) {
        try {
            client.disconnect();
        }
        catch (IOException e) {
            logger.warn("Failed to close FTPClient", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResponseData(String uri, boolean includeContent, ResponseData responseData, FTPClient client, FtpInfo ftpInfo, FTPFile file) {
        if (file == null) {
            responseData.setHttpStatusCode(404);
            responseData.setCharSet(this.charset);
            responseData.setContentLength(0L);
            this.ftpClientQueue.offer(client);
            return;
        }
        if (file.isSymbolicLink()) {
            String link = file.getLink();
            String redirect = null;
            if (link == null) {
                responseData.setHttpStatusCode(400);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
                this.ftpClientQueue.offer(client);
                return;
            }
            redirect = link.startsWith("/") ? ftpInfo.toUrl(file.getLink()) : (link.startsWith("../") ? ftpInfo.toChildUrl(file.getLink()) : ftpInfo.toChildUrl("../" + file.getLink()));
            if (!uri.equals(redirect)) {
                responseData.setHttpStatusCode(0);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
                responseData.setRedirectLocation(redirect);
                this.ftpClientQueue.offer(client);
                return;
            }
        }
        if (file.isFile()) {
            responseData.setHttpStatusCode(200);
            responseData.setCharSet("UTF-8");
            responseData.setLastModified(file.getTimestamp().getTime());
            responseData.setContentLength(file.getSize());
            this.checkMaxContentLength(responseData);
            if (file.getUser() != null) {
                responseData.addMetaData(FTP_FILE_USER, file.getUser());
            }
            if (file.getGroup() != null) {
                responseData.addMetaData(FTP_FILE_GROUP, file.getGroup());
            }
            if (includeContent) {
                File tempFile = null;
                File outputFile = null;
                try {
                    tempFile = File.createTempFile("ftp-", ".tmp");
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
                        if (!client.retrieveFile(ftpInfo.getName(), (OutputStream)out)) {
                            throw new CrawlingAccessException("Failed to retrieve: " + ftpInfo.toUrl());
                        }
                    }
                    MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                    try (FileInputStream is = new FileInputStream(tempFile);){
                        responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
                    }
                    catch (Exception e) {
                        responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                    }
                    if (this.contentLengthHelper != null) {
                        long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                        if (responseData.getContentLength() > maxLength) {
                            throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + uri);
                        }
                    }
                    responseData.setCharSet(this.geCharSet(tempFile));
                    if (tempFile.length() < this.maxCachedContentSize) {
                        try (BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(tempFile));){
                            responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)contentStream));
                        }
                    } else {
                        outputFile = File.createTempFile("crawler-FtpClient-", ".out");
                        CopyUtil.copy((File)tempFile, (File)outputFile);
                        responseData.setResponseBody(outputFile, true);
                    }
                    this.ftpClientQueue.offer(client);
                }
                catch (CrawlingAccessException e) {
                    this.ftpClientQueue.offer(client);
                    throw e;
                }
                catch (Exception e) {
                    logger.warn("I/O Exception.", (Throwable)e);
                    this.disconnectInternalClient(client);
                    responseData.setHttpStatusCode(500);
                }
                finally {
                    FileUtil.deleteInBackground((File)tempFile);
                }
            }
        } else {
            if (file.isDirectory() || file.isSymbolicLink()) {
                HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                if (includeContent) {
                    try {
                        FTPFile[] ftpFiles = client.listFiles(ftpInfo.getName(), FTPFileFilters.NON_NULL);
                        this.validateRequest(client);
                        for (FTPFile f : ftpFiles) {
                            String chileUri = ftpInfo.toChildUrl(f.getName());
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                        }
                    }
                    catch (IOException e) {
                        this.disconnectInternalClient(client);
                        throw new CrawlingAccessException("Could not access " + uri, e);
                    }
                }
                this.ftpClientQueue.offer(client);
                throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData");
            }
            responseData.setHttpStatusCode(400);
            responseData.setCharSet(this.charset);
            responseData.setContentLength(0L);
            this.ftpClientQueue.offer(client);
        }
    }

    private void validateRequest(FTPClient client) {
        int replyCode = client.getReplyCode();
        if (replyCode >= 200 && replyCode < 300) {
            return;
        }
        throw new CrawlingAccessException("Failed FTP request: " + client.getReplyString().trim());
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }

    protected FTPClient getClient(FtpInfo info) throws IOException {
        FTPClient ftpClient = this.ftpClientQueue.poll();
        if (ftpClient != null) {
            if (ftpClient.isAvailable()) {
                return ftpClient;
            }
            try {
                ftpClient.disconnect();
            }
            catch (Exception e) {
                logger.debug("Failed to disconnect {}", (Object)info.toUrl(), (Object)e);
            }
        }
        try {
            if (this.isImplicit != null) {
                FTPSClient ftpsClient = new FTPSClient(this.isImplicit.booleanValue());
                if ("all".equals(this.trustManager)) {
                    ftpsClient.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
                } else if ("valid".equals(this.trustManager)) {
                    ftpsClient.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
                } else if ("none".equals(this.trustManager)) {
                    ftpsClient.setTrustManager(null);
                }
                ftpClient = ftpsClient;
            } else {
                ftpClient = new FTPClient();
            }
            if (this.activeExternalHost != null) {
                ftpClient.setActiveExternalIPAddress(this.activeExternalHost);
            }
            if (this.passiveLocalHost != null) {
                ftpClient.setPassiveLocalIPAddress(this.passiveLocalHost);
            }
            if (this.reportActiveExternalHost != null) {
                ftpClient.setReportActiveExternalIPAddress(this.reportActiveExternalHost);
            }
            if (this.activeMinPort != -1 && this.activeMaxPort != -1) {
                ftpClient.setActivePortRange(this.activeMinPort, this.activeMaxPort);
            }
            ftpClient.setAutodetectUTF8(this.autodetectEncoding);
            ftpClient.setConnectTimeout(this.connectTimeout);
            ftpClient.setDataTimeout(Duration.ofMillis(this.dataTimeout));
            ftpClient.setControlEncoding(this.controlEncoding);
            ftpClient.setBufferSize(this.bufferSize);
            if (this.passiveNatWorkaround) {
                ftpClient.setPassiveNatWorkaroundStrategy((FTPClient.HostnameResolver)new FTPClient.NatServerResolverImpl(ftpClient));
            }
            ftpClient.setUseEPSVwithIPv4(this.useEPSVwithIPv4);
            ftpClient.configure(this.ftpClientConfig);
            ftpClient.connect(info.getHost(), info.getPort());
            this.validateRequest(ftpClient);
            FtpAuthentication auth = this.ftpAuthenticationHolder.get(info.toUrl());
            if (auth != null && !ftpClient.login(auth.getUsername(), auth.getPassword())) {
                throw new CrawlerLoginFailureException("Login Failure: " + auth.getUsername() + " for " + info.toUrl());
            }
            ftpClient.setFileType(2);
            return ftpClient;
        }
        catch (IOException e) {
            if (ftpClient != null) {
                try {
                    ftpClient.disconnect();
                }
                catch (Exception e1) {
                    logger.debug("Failed to disconnect {}", (Object)info.toUrl(), (Object)e);
                }
            }
            throw e;
        }
    }

    public String getActiveExternalHost() {
        return this.activeExternalHost;
    }

    public void setActiveExternalHost(String activeExternalHost) {
        this.activeExternalHost = activeExternalHost;
    }

    public int getActiveMinPort() {
        return this.activeMinPort;
    }

    public void setActiveMinPort(int activeMinPort) {
        this.activeMinPort = activeMinPort;
    }

    public int getActiveMaxPort() {
        return this.activeMaxPort;
    }

    public void setActiveMaxPort(int activeMaxPort) {
        this.activeMaxPort = activeMaxPort;
    }

    public boolean isAutodetectEncoding() {
        return this.autodetectEncoding;
    }

    public void setAutodetectEncoding(boolean autodetectEncoding) {
        this.autodetectEncoding = autodetectEncoding;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getDataTimeout() {
        return this.dataTimeout;
    }

    public void setDataTimeout(int dataTimeout) {
        this.dataTimeout = dataTimeout;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        this.controlEncoding = controlEncoding;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getPassiveLocalHost() {
        return this.passiveLocalHost;
    }

    public void setPassiveLocalHost(String passiveLocalHost) {
        this.passiveLocalHost = passiveLocalHost;
    }

    public boolean isPassiveNatWorkaround() {
        return this.passiveNatWorkaround;
    }

    public void setPassiveNatWorkaround(boolean passiveNatWorkaround) {
        this.passiveNatWorkaround = passiveNatWorkaround;
    }

    public String getReportActiveExternalHost() {
        return this.reportActiveExternalHost;
    }

    public void setReportActiveExternalHost(String reportActiveExternalHost) {
        this.reportActiveExternalHost = reportActiveExternalHost;
    }

    public boolean isUseEPSVwithIPv4() {
        return this.useEPSVwithIPv4;
    }

    public void setUseEPSVwithIPv4(boolean useEPSVwithIPv4) {
        this.useEPSVwithIPv4 = useEPSVwithIPv4;
    }

    public void setFtpAuthenticationHolder(FtpAuthenticationHolder ftpAuthenticationHolder) {
        this.ftpAuthenticationHolder = ftpAuthenticationHolder;
    }

    public static class FtpInfo {
        private static final int DEFAULT_FTP_PORT = 21;
        private URL uri;
        private String parent;
        private String name;

        public FtpInfo(String s) {
            try {
                this.uri = new URL(this.normalize(s));
            }
            catch (MalformedURLException e) {
                throw new CrawlingAccessException("Invalid URL: " + s, e);
            }
            String path = this.uri.getPath();
            if (path == null) {
                this.parent = "/";
                this.name = null;
            } else {
                Object[] values = path.replaceAll("/+", "/").replaceFirst("/$", "").split("/");
                if (values.length == 1) {
                    this.parent = "/";
                    this.name = null;
                } else if (values.length == 2) {
                    this.parent = "/";
                    this.name = values[1];
                } else {
                    this.parent = StringUtils.join((Object[])values, (String)"/", (int)0, (int)(values.length - 1));
                    this.name = values[values.length - 1];
                }
            }
        }

        protected String normalize(String s) {
            if (s == null) {
                return null;
            }
            String url = s.replaceAll("/+", "/").replace("ftp:/", "ftp://");
            while (url.indexOf("/../") != -1) {
                url = url.replaceFirst("/[^/]+/\\.\\./", "/");
            }
            return url;
        }

        public String getCacheKey() {
            return this.getHost() + ":" + this.getPort();
        }

        public String getHost() {
            return this.uri.getHost();
        }

        public int getPort() {
            int port = this.uri.getPort();
            if (port == -1) {
                port = 21;
            }
            return port;
        }

        public String toUrl(String path) {
            StringBuilder buf = new StringBuilder(100);
            buf.append("ftp://");
            buf.append(this.getHost());
            int port = this.getPort();
            if (port != 21) {
                buf.append(':').append(port);
            }
            buf.append(path);
            String url = this.normalize(buf.toString());
            if ("/".equals(path)) {
                return url;
            }
            return url.replaceAll("/+$", "");
        }

        public String toUrl() {
            return this.toUrl(this.uri.getPath());
        }

        public String toChildUrl(String child) {
            String url = this.toUrl();
            if (url.endsWith("/")) {
                return this.normalize(this.toUrl() + child);
            }
            return this.normalize(this.toUrl() + "/" + child);
        }

        public String getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }
    }
}

