/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.ftp;

import java.net.URL;
import org.codelibs.core.lang.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpAuthentication {
    private static final Logger logger = LoggerFactory.getLogger(FtpAuthentication.class);
    private String server;
    private int port;
    private String username;
    private String password;

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    boolean matches(String path) {
        if (StringUtil.isBlank((String)path)) {
            return false;
        }
        try {
            int pos = path.indexOf(47, 6);
            URL uri = new URL(pos == -1 ? path : path.substring(0, pos));
            if (!"ftp".equals(uri.getProtocol()) || StringUtil.isNotBlank((String)this.server) && !this.server.equals(uri.getHost())) {
                return false;
            }
            int p = uri.getPort();
            if (p == -1) {
                p = 21;
            }
            return this.port <= 0 || this.port == p;
        }
        catch (Exception e) {
            logger.debug("Invalid URI: {}", (Object)path, (Object)e);
            return false;
        }
    }
}

