/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client.fs;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.codelibs.core.io.CloseableUtil;
import org.codelibs.core.io.InputStreamUtil;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.timer.TimeoutManager;
import org.codelibs.core.timer.TimeoutTarget;
import org.codelibs.core.timer.TimeoutTask;
import org.codelibs.fess.crawler.builder.RequestDataBuilder;
import org.codelibs.fess.crawler.client.AbstractCrawlerClient;
import org.codelibs.fess.crawler.client.AccessTimeoutTarget;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.ChildUrlsException;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.exception.CrawlingAccessException;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.helper.ContentLengthHelper;
import org.codelibs.fess.crawler.helper.MimeTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemClient
extends AbstractCrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemClient.class);
    public static final String FILE_ATTRIBUTE_VIEW = "fileAttributeView";
    public static final String FS_FILE_USER = "fsFileUser";
    public static final String FS_FILE_GROUPS = "fsFileGroups";
    protected String charset = "UTF-8";
    @Resource
    protected ContentLengthHelper contentLengthHelper;
    protected AtomicBoolean isInit = new AtomicBoolean(false);

    @Override
    public ResponseData doGet(String uri) {
        return this.processRequest(uri, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResponseData processRequest(String uri, boolean includeContent) {
        if (!this.isInit.get()) {
            AtomicBoolean atomicBoolean = this.isInit;
            synchronized (atomicBoolean) {
                if (!this.isInit.get()) {
                    this.init();
                    this.isInit.set(true);
                }
            }
        }
        AccessTimeoutTarget accessTimeoutTarget = null;
        TimeoutTask accessTimeoutTask = null;
        if (this.accessTimeout != null) {
            accessTimeoutTarget = new AccessTimeoutTarget(Thread.currentThread());
            accessTimeoutTask = TimeoutManager.getInstance().addTimeoutTarget((TimeoutTarget)accessTimeoutTarget, this.accessTimeout.intValue(), false);
        }
        try {
            ResponseData responseData = this.getResponseData(uri, includeContent);
            return responseData;
        }
        finally {
            if (accessTimeoutTarget != null) {
                accessTimeoutTarget.stop();
                if (!accessTimeoutTask.isCanceled()) {
                    accessTimeoutTask.cancel();
                }
            }
        }
    }

    protected ResponseData getResponseData(String uri, boolean includeContent) {
        ResponseData responseData;
        block28: {
            responseData = new ResponseData();
            try {
                responseData.setMethod("GET");
                String filePath = this.preprocessUri(uri);
                responseData.setUrl(filePath);
                File file = null;
                try {
                    file = new File(new URI(filePath));
                }
                catch (URISyntaxException e) {
                    logger.warn("Could not parse url: " + filePath, (Throwable)e);
                }
                if (file == null) {
                    responseData.setHttpStatusCode(404);
                    responseData.setCharSet(this.charset);
                    responseData.setContentLength(0L);
                    break block28;
                }
                if (file.isFile()) {
                    responseData.setContentLength(file.length());
                    this.checkMaxContentLength(responseData);
                    this.parseFileOwnerAttribute(responseData, file);
                    responseData.setHttpStatusCode(200);
                    responseData.setCharSet(this.geCharSet(file));
                    responseData.setLastModified(new Date(file.lastModified()));
                    if (file.canRead()) {
                        MimeTypeHelper mimeTypeHelper = (MimeTypeHelper)this.crawlerContainer.getComponent("mimeTypeHelper");
                        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                            responseData.setMimeType(mimeTypeHelper.getContentType((InputStream)is, file.getName()));
                        }
                        catch (Exception e) {
                            responseData.setMimeType(mimeTypeHelper.getContentType(null, file.getName()));
                        }
                        if (this.contentLengthHelper != null) {
                            long maxLength = this.contentLengthHelper.getMaxLength(responseData.getMimeType());
                            if (responseData.getContentLength() > maxLength) {
                                throw new MaxLengthExceededException("The content length (" + responseData.getContentLength() + " byte) is over " + maxLength + " byte. The url is " + filePath);
                            }
                        }
                        if (!includeContent) break block28;
                        if (file.length() < this.maxCachedContentSize) {
                            try (BufferedInputStream contentStream = new BufferedInputStream(new FileInputStream(file));){
                                responseData.setResponseBody(InputStreamUtil.getBytes((InputStream)contentStream));
                                break block28;
                            }
                            catch (Exception e) {
                                logger.warn("I/O Exception.", (Throwable)e);
                                responseData.setHttpStatusCode(500);
                            }
                            break block28;
                        }
                        responseData.setResponseBody(file, false);
                        break block28;
                    }
                    responseData.setHttpStatusCode(403);
                    responseData.setMimeType("application/octet-stream");
                    break block28;
                }
                if (file.isDirectory()) {
                    File[] files;
                    HashSet<RequestData> requestDataSet = new HashSet<RequestData>();
                    if (includeContent && (files = file.listFiles()) != null) {
                        for (File f : files) {
                            String chileUri = f.toURI().toASCIIString();
                            requestDataSet.add(RequestDataBuilder.newRequestData().get().url(chileUri).build());
                        }
                    }
                    throw new ChildUrlsException(requestDataSet, this.getClass().getName() + "#getResponseData");
                }
                responseData.setHttpStatusCode(404);
                responseData.setCharSet(this.charset);
                responseData.setContentLength(0L);
            }
            catch (CrawlerSystemException e) {
                CloseableUtil.closeQuietly((Closeable)responseData);
                throw e;
            }
            catch (Exception e) {
                CloseableUtil.closeQuietly((Closeable)responseData);
                throw new CrawlingAccessException("Could not access " + uri, e);
            }
        }
        return responseData;
    }

    protected FileOwnerAttributeView parseFileOwnerAttribute(ResponseData responseData, File file) {
        try {
            AclFileAttributeView aclFileAttributeView;
            UserPrincipal owner;
            FileOwnerAttributeView ownerAttrView = Files.getFileAttributeView(file.toPath(), FileOwnerAttributeView.class, new LinkOption[0]);
            if (ownerAttrView != null && (owner = ownerAttrView.getOwner()) != null) {
                responseData.addMetaData(FS_FILE_USER, owner.getName());
            }
            if ((aclFileAttributeView = Files.getFileAttributeView(file.toPath(), AclFileAttributeView.class, new LinkOption[0])) != null) {
                responseData.addMetaData(FILE_ATTRIBUTE_VIEW, aclFileAttributeView);
                responseData.addMetaData(FS_FILE_GROUPS, aclFileAttributeView.getAcl().stream().map(acl -> acl.principal().getName()).toArray(String[]::new));
                return aclFileAttributeView;
            }
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(file.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView != null) {
                responseData.addMetaData(FILE_ATTRIBUTE_VIEW, posixFileAttributeView);
                responseData.addMetaData(FS_FILE_GROUPS, new String[]{posixFileAttributeView.readAttributes().group().getName()});
                return posixFileAttributeView;
            }
            return ownerAttrView;
        }
        catch (Exception e) {
            throw new CrawlingAccessException("Failed to parse FileAttributeView.", e);
        }
    }

    protected String preprocessUri(String uri) {
        if (StringUtil.isEmpty((String)uri)) {
            throw new CrawlerSystemException("The uri is empty.");
        }
        Object filePath = uri;
        if (!((String)filePath).startsWith("file:")) {
            filePath = "file://" + (String)filePath;
        }
        StringBuilder buf = new StringBuilder(((String)filePath).length() + 100);
        try {
            for (char c : ((String)filePath).toCharArray()) {
                if (c == ' ') {
                    buf.append("%20");
                    continue;
                }
                String str = String.valueOf(c);
                if (StringUtil.isAsciiPrintable((CharSequence)str)) {
                    buf.append(c);
                    continue;
                }
                buf.append(URLEncoder.encode(str, this.charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            return filePath;
        }
        return buf.toString();
    }

    protected String geCharSet(File file) {
        return this.charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public ResponseData doHead(String url) {
        try {
            ResponseData responseData = this.processRequest(url, false);
            responseData.setMethod("HEAD");
            return responseData;
        }
        catch (ChildUrlsException e) {
            return null;
        }
    }
}

