/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.codelibs.core.lang.ThreadUtil;
import org.codelibs.fess.crawler.client.CrawlerClient;
import org.codelibs.fess.crawler.entity.RequestData;
import org.codelibs.fess.crawler.entity.ResponseData;
import org.codelibs.fess.crawler.exception.MaxLengthExceededException;
import org.codelibs.fess.crawler.exception.MultipleCrawlingAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaultTolerantClient
implements CrawlerClient {
    private static final Logger logger = LoggerFactory.getLogger(FaultTolerantClient.class);
    protected CrawlerClient client;
    protected int maxRetryCount = 5;
    protected long retryInterval = 500L;
    protected RequestListener listener;

    @Override
    public void setInitParameterMap(Map<String, Object> params) {
        this.client.setInitParameterMap(params);
    }

    @Override
    public ResponseData execute(RequestData request) {
        if (this.listener != null) {
            this.listener.onRequestStart(this, request);
        }
        ArrayList<Exception> exceptionList = null;
        try {
            for (int count = 0; count < this.maxRetryCount; ++count) {
                if (this.listener != null) {
                    this.listener.onRequest(this, request, count);
                }
                try {
                    ResponseData responseData = this.client.execute(request);
                    return responseData;
                }
                catch (MaxLengthExceededException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to access to {}", (Object)request.getUrl(), (Object)e3);
                    }
                    if (this.listener != null) {
                        this.listener.onException(this, request, count, e3);
                    }
                    if (exceptionList == null) {
                        exceptionList = new ArrayList<Exception>();
                    }
                    exceptionList.add(e3);
                    ThreadUtil.sleep((long)this.retryInterval);
                    continue;
                }
            }
            String message = "Failed to access to " + request.getUrl() + exceptionList.stream().map(e -> "; " + e.getMessage()).collect(Collectors.joining());
            throw new MultipleCrawlingAccessException(message, exceptionList.toArray(new Throwable[exceptionList.size()]));
        }
        finally {
            if (this.listener != null) {
                this.listener.onRequestEnd(this, request, (List<Exception>)exceptionList);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    public CrawlerClient getCrawlerClient() {
        return this.client;
    }

    public void setCrawlerClient(CrawlerClient client) {
        this.client = client;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
    }

    public RequestListener getRequestListener() {
        return this.listener;
    }

    public void setRequestListener(RequestListener listener) {
        this.listener = listener;
    }

    public static interface RequestListener {
        public void onRequestStart(FaultTolerantClient var1, RequestData var2);

        public void onRequest(FaultTolerantClient var1, RequestData var2, int var3);

        public void onRequestEnd(FaultTolerantClient var1, RequestData var2, List<Exception> var3);

        public void onException(FaultTolerantClient var1, RequestData var2, int var3, Exception var4);
    }
}

