/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.client;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.codelibs.fess.crawler.client.CrawlerClient;
import org.codelibs.fess.crawler.client.CrawlerClientFactory;
import org.codelibs.fess.crawler.container.CrawlerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerClientCreator {
    private static final Logger logger = LoggerFactory.getLogger(CrawlerClientCreator.class);
    @Resource
    protected CrawlerContainer crawlerContainer;
    protected Map<String, String> clientMap = new LinkedHashMap<String, String>();
    protected List<CrawlerClientFactory> clientFactoryList = new LinkedList<CrawlerClientFactory>();
    protected int maxClientFactorySize = 10000;

    public synchronized void register(CrawlerClientFactory crawlerClientFactory) {
        this.clientMap.entrySet().stream().forEach(e -> this.load(crawlerClientFactory, (String)e.getKey(), (String)e.getValue()));
        this.clientFactoryList.add(crawlerClientFactory);
        if (this.clientFactoryList.size() > this.maxClientFactorySize) {
            this.clientFactoryList.remove(0);
        }
    }

    public synchronized void register(String regex, String componentName) {
        this.clientMap.put(regex, componentName);
        this.clientFactoryList.forEach(f -> this.load((CrawlerClientFactory)f, regex, componentName));
    }

    protected void load(CrawlerClientFactory crawlerClientFactory, String regex, String componentName) {
        block7: {
            if (logger.isDebugEnabled()) {
                logger.debug("loading {}", (Object)componentName);
            }
            CrawlerClient client = null;
            try {
                client = (CrawlerClient)this.crawlerContainer.getComponent(componentName);
                crawlerClientFactory.addClient(regex, client);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to create {}.", (Object)componentName, (Object)e);
                } else {
                    logger.info("{} is not available.", (Object)componentName);
                }
                if (client == null) break block7;
                try {
                    client.close();
                }
                catch (Exception ex) {
                    logger.warn("Failed to close {}.", (Object)componentName, (Object)ex);
                }
            }
        }
    }

    public void setMaxClientFactorySize(int maxClientFactorySize) {
        this.maxClientFactorySize = maxClientFactorySize;
    }
}

