/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.codelibs.core.collection.LruHashSet;
import org.codelibs.fess.crawler.CrawlerStatus;
import org.codelibs.fess.crawler.filter.UrlFilter;
import org.codelibs.fess.crawler.interval.IntervalController;
import org.codelibs.fess.crawler.rule.RuleManager;

public class CrawlerContext {
    protected String sessionId;
    protected Integer activeThreadCount = 0;
    protected Object activeThreadCountLock = new Object();
    protected AtomicLong accessCount = new AtomicLong(0L);
    protected volatile CrawlerStatus status = CrawlerStatus.INITIALIZING;
    protected UrlFilter urlFilter;
    protected RuleManager ruleManager;
    protected IntervalController intervalController;
    protected Set<String> robotsTxtUrlSet = new LruHashSet(10000);
    protected ThreadLocal<String[]> sitemapsLocal = new ThreadLocal();
    protected int numOfThread = 10;
    protected int maxThreadCheckCount = 20;
    protected int maxDepth = -1;
    protected long maxAccessCount = 0L;

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Integer getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public void setActiveThreadCount(Integer activeThreadCount) {
        this.activeThreadCount = activeThreadCount;
    }

    public long getAccessCount() {
        return this.accessCount.get();
    }

    public long incrementAndGetAccessCount() {
        return this.accessCount.incrementAndGet();
    }

    public long decrementAndGetAccessCount() {
        return this.accessCount.decrementAndGet();
    }

    public CrawlerStatus getStatus() {
        return this.status;
    }

    public void setStatus(CrawlerStatus status) {
        this.status = status;
    }

    public UrlFilter getUrlFilter() {
        return this.urlFilter;
    }

    public void setUrlFilter(UrlFilter urlFilter) {
        this.urlFilter = urlFilter;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRuleManager(RuleManager ruleManager) {
        this.ruleManager = ruleManager;
    }

    public IntervalController getIntervalController() {
        return this.intervalController;
    }

    public void setIntervalController(IntervalController intervalController) {
        this.intervalController = intervalController;
    }

    public Set<String> getRobotsTxtUrlSet() {
        return this.robotsTxtUrlSet;
    }

    public void setRobotsTxtUrlSet(Set<String> robotsTxtUrlSet) {
        this.robotsTxtUrlSet = robotsTxtUrlSet;
    }

    public Object getActiveThreadCountLock() {
        return this.activeThreadCountLock;
    }

    public int getNumOfThread() {
        return this.numOfThread;
    }

    public void setNumOfThread(int numOfThread) {
        this.numOfThread = numOfThread;
    }

    public int getMaxThreadCheckCount() {
        return this.maxThreadCheckCount;
    }

    public void setMaxThreadCheckCount(int maxThreadCheckCount) {
        this.maxThreadCheckCount = maxThreadCheckCount;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public long getMaxAccessCount() {
        return this.maxAccessCount;
    }

    public void setMaxAccessCount(long maxAccessCount) {
        this.maxAccessCount = maxAccessCount;
    }

    public void addSitemaps(String[] sitemaps) {
        this.sitemapsLocal.set(sitemaps);
    }

    public String[] removeSitemaps() {
        String[] sitemaps = this.sitemapsLocal.get();
        if (sitemaps != null) {
            this.sitemapsLocal.remove();
        }
        return sitemaps;
    }
}

