/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.fess.crawler.interval.impl;

import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.codelibs.core.exception.InterruptedRuntimeException;
import org.codelibs.core.lang.StringUtil;
import org.codelibs.core.lang.SystemUtil;
import org.codelibs.fess.crawler.entity.UrlQueue;
import org.codelibs.fess.crawler.exception.CrawlerSystemException;
import org.codelibs.fess.crawler.interval.impl.DefaultIntervalController;
import org.codelibs.fess.crawler.util.CrawlingParameterUtil;

public class HostIntervalController
extends DefaultIntervalController {
    private final ConcurrentMap<String, AtomicLong> lastTimes = new ConcurrentHashMap<String, AtomicLong>();

    public HostIntervalController() {
    }

    public HostIntervalController(Map<String, Long> params) {
        super(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delayBeforeProcessing() {
        UrlQueue<?> urlQueue = CrawlingParameterUtil.getUrlQueue();
        if (urlQueue == null) {
            return;
        }
        String url = urlQueue.getUrl();
        if (StringUtil.isBlank((String)url) || url.startsWith("file:")) {
            return;
        }
        try {
            URL u = new URL(url);
            String host = u.getHost();
            if (host == null) {
                return;
            }
            AtomicLong lastTime = this.lastTimes.putIfAbsent(host, new AtomicLong(SystemUtil.currentTimeMillis()));
            if (lastTime == null) {
                return;
            }
            AtomicLong atomicLong = lastTime;
            synchronized (atomicLong) {
                long currentTime;
                while (true) {
                    currentTime = SystemUtil.currentTimeMillis();
                    long delayTime = lastTime.get() + this.delayMillisBeforeProcessing - currentTime;
                    if (delayTime <= 0L) break;
                    lastTime.wait(delayTime);
                }
                lastTime.set(currentTime);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException(e);
        }
        catch (Exception e) {
            throw new CrawlerSystemException(e);
        }
    }
}

